
const BaseModel = require("./basemodel");
class User extends BaseModel {
	static init(sequelize, Sequelize) {
		return super.init(
			{
				
				id: { type: Sequelize.INTEGER, primaryKey: true , autoIncrement: true },
				name: {name: 'name', type:Sequelize.STRING},
				email: {name: 'email', type:Sequelize.STRING},
				senha: {name: 'senha', type:Sequelize.STRING},
				foto: {name: 'foto', type:Sequelize.STRING},
				saldo: {name: 'saldo', type:Sequelize.STRING},
				port: {name: 'port', type:Sequelize.INTEGER},
				user_role_id: {name: 'user_role_id', type:Sequelize.INTEGER}
			}, 
			{ 
				sequelize,
				
				tableName: "user",
				modelName: "user",
			}
		);
	}
	
	static listFields() {
		let sequelize = this.sequelize;
		return [
			'id', 
			'name', 
			'email', 
			'foto', 
			'saldo', 
			'port', 
			'user_role_id'
		];
	}

	static exportListFields() {
		let sequelize = this.sequelize;
		return [
			'id', 
			'name', 
			'email', 
			'foto', 
			'saldo', 
			'port', 
			'user_role_id'
		];
	}

	static viewFields() {
		let sequelize = this.sequelize;
		return [
			'id', 
			'name', 
			'email', 
			'saldo', 
			'port', 
			'user_role_id'
		];
	}

	static exportViewFields() {
		let sequelize = this.sequelize;
		return [
			'id', 
			'name', 
			'email', 
			'saldo', 
			'port', 
			'user_role_id'
		];
	}

	static accounteditFields() {
		let sequelize = this.sequelize;
		return [
			'id', 
			'name', 
			'foto', 
			'saldo', 
			'port', 
			'user_role_id'
		];
	}

	static accountviewFields() {
		let sequelize = this.sequelize;
		return [
			'id', 
			'name', 
			'email', 
			'saldo', 
			'port', 
			'user_role_id'
		];
	}

	static exportAccountviewFields() {
		let sequelize = this.sequelize;
		return [
			'id', 
			'name', 
			'email', 
			'saldo', 
			'port', 
			'user_role_id'
		];
	}

	static editFields() {
		let sequelize = this.sequelize;
		return [
			'id', 
			'name', 
			'foto', 
			'saldo', 
			'port', 
			'user_role_id'
		];
	}

	
	static searchFields(){
		let sequelize = this.sequelize;
		return [
			sequelize.literal("name LIKE :search"), 
			sequelize.literal("email LIKE :search"), 
			sequelize.literal("saldo LIKE :search"),
		];
	}

	
	
}
module.exports = User;
