
const BaseModel = require("./basemodel");
class Sms extends BaseModel {
	static init(sequelize, Sequelize) {
		return super.init(
			{
				
				id: { type: Sequelize.INTEGER, primaryKey: true , autoIncrement: true },
				tipo: {name: 'tipo', type:Sequelize.STRING},
				start_datatime: {name: 'start_datatime', type:Sequelize.DATE},
				conteudo: {name: 'conteudo', type:Sequelize.STRING},
				date_created: {name: 'date_created', type:Sequelize.DATE},
				date_updated: {name: 'date_updated', type:Sequelize.DATE},
				status: {name: 'status', type:Sequelize.STRING},
				id_grupo: {name: 'id_grupo', type:Sequelize.STRING},
				id_user: {name: 'id_user', type:Sequelize.STRING},
				contacto: {name: 'contacto', type:Sequelize.STRING}
			}, 
			{ 
				sequelize,
				
				tableName: "sms",
				modelName: "sms",
			}
		);
	}
	
	static listFields() {
		let sequelize = this.sequelize;
		return [
			'id', 
			'tipo', 
			'start_datatime', 
			'conteudo', 
			'date_created', 
			'status', 
			'id_user', 
			'contacto'
		];
	}

	static exportListFields() {
		let sequelize = this.sequelize;
		return [
			'id', 
			'tipo', 
			'start_datatime', 
			'conteudo', 
			'date_created', 
			'status', 
			'id_user', 
			'contacto'
		];
	}

	static viewFields() {
		let sequelize = this.sequelize;
		return [
			'id', 
			'tipo', 
			'start_datatime', 
			'conteudo', 
			'date_created', 
			'date_updated', 
			'status', 
			'id_grupo', 
			'id_user', 
			'contacto'
		];
	}

	static exportViewFields() {
		let sequelize = this.sequelize;
		return [
			'id', 
			'tipo', 
			'start_datatime', 
			'conteudo', 
			'date_created', 
			'date_updated', 
			'status', 
			'id_grupo', 
			'id_user', 
			'contacto'
		];
	}

	static editFields() {
		let sequelize = this.sequelize;
		return [
			'id', 
			'tipo', 
			'id_grupo', 
			'contacto', 
			'conteudo', 
			'status'
		];
	}

	
	static searchFields(){
		let sequelize = this.sequelize;
		return [
			sequelize.literal("tipo LIKE :search"), 
			sequelize.literal("conteudo LIKE :search"), 
			sequelize.literal("status LIKE :search"), 
			sequelize.literal("id_grupo LIKE :search"), 
			sequelize.literal("id_user LIKE :search"), 
			sequelize.literal("contacto LIKE :search"),
		];
	}

	
	
}
module.exports = Sms;
