
const BaseModel = require("./basemodel");
class App_Logs extends BaseModel {
	static init(sequelize, Sequelize) {
		return super.init(
			{
				
				log_id: { type: Sequelize.INTEGER, primaryKey: true , autoIncrement: true },
				timestamp: {name: 'Timestamp', type:Sequelize.STRING},
				action: {name: 'Action', type:Sequelize.STRING},
				tablename: {name: 'TableName', type:Sequelize.STRING},
				recordid: {name: 'RecordID', type:Sequelize.STRING},
				sqlquery: {name: 'SqlQuery', type:Sequelize.STRING},
				userid: {name: 'UserID', type:Sequelize.STRING},
				serverip: {name: 'ServerIP', type:Sequelize.STRING},
				requesturl: {name: 'RequestUrl', type:Sequelize.STRING},
				requestdata: {name: 'RequestData', type:Sequelize.STRING},
				requestcompleted: {name: 'RequestCompleted', type:Sequelize.STRING},
				requestmsg: {name: 'RequestMsg', type:Sequelize.STRING}
			}, 
			{ 
				sequelize,
				
				tableName: "app_logs",
				modelName: "app_logs",
			}
		);
	}
	
	static listFields() {
		let sequelize = this.sequelize;
		return [
			'log_id', 
			sequelize.literal('Timestamp AS timestamp'), 
			sequelize.literal('Action AS action'), 
			sequelize.literal('TableName AS tablename'), 
			sequelize.literal('RecordID AS recordid'), 
			sequelize.literal('SqlQuery AS sqlquery'), 
			sequelize.literal('UserID AS userid'), 
			sequelize.literal('ServerIP AS serverip'), 
			sequelize.literal('RequestUrl AS requesturl'), 
			sequelize.literal('RequestData AS requestdata'), 
			sequelize.literal('RequestCompleted AS requestcompleted'), 
			sequelize.literal('RequestMsg AS requestmsg')
		];
	}

	static exportListFields() {
		let sequelize = this.sequelize;
		return [
			'log_id', 
			sequelize.literal('Timestamp AS timestamp'), 
			sequelize.literal('Action AS action'), 
			sequelize.literal('TableName AS tablename'), 
			sequelize.literal('RecordID AS recordid'), 
			sequelize.literal('SqlQuery AS sqlquery'), 
			sequelize.literal('UserID AS userid'), 
			sequelize.literal('ServerIP AS serverip'), 
			sequelize.literal('RequestUrl AS requesturl'), 
			sequelize.literal('RequestData AS requestdata'), 
			sequelize.literal('RequestCompleted AS requestcompleted'), 
			sequelize.literal('RequestMsg AS requestmsg')
		];
	}

	static viewFields() {
		let sequelize = this.sequelize;
		return [
			'log_id', 
			sequelize.literal('Timestamp AS timestamp'), 
			sequelize.literal('Action AS action'), 
			sequelize.literal('TableName AS tablename'), 
			sequelize.literal('RecordID AS recordid'), 
			sequelize.literal('SqlQuery AS sqlquery'), 
			sequelize.literal('UserID AS userid'), 
			sequelize.literal('ServerIP AS serverip'), 
			sequelize.literal('RequestUrl AS requesturl'), 
			sequelize.literal('RequestData AS requestdata'), 
			sequelize.literal('RequestCompleted AS requestcompleted'), 
			sequelize.literal('RequestMsg AS requestmsg')
		];
	}

	static exportViewFields() {
		let sequelize = this.sequelize;
		return [
			'log_id', 
			sequelize.literal('Timestamp AS timestamp'), 
			sequelize.literal('Action AS action'), 
			sequelize.literal('TableName AS tablename'), 
			sequelize.literal('RecordID AS recordid'), 
			sequelize.literal('SqlQuery AS sqlquery'), 
			sequelize.literal('UserID AS userid'), 
			sequelize.literal('ServerIP AS serverip'), 
			sequelize.literal('RequestUrl AS requesturl'), 
			sequelize.literal('RequestData AS requestdata'), 
			sequelize.literal('RequestCompleted AS requestcompleted'), 
			sequelize.literal('RequestMsg AS requestmsg')
		];
	}

	static editFields() {
		let sequelize = this.sequelize;
		return [
			'log_id', 
			'timestamp', 
			'action', 
			'tablename', 
			'recordid', 
			'sqlquery', 
			'userid', 
			'serverip', 
			'requesturl', 
			'requestdata', 
			'requestcompleted', 
			'requestmsg'
		];
	}

	
	static searchFields(){
		let sequelize = this.sequelize;
		return [
			sequelize.literal("Timestamp LIKE :search"), 
			sequelize.literal("Action LIKE :search"), 
			sequelize.literal("TableName LIKE :search"), 
			sequelize.literal("RecordID LIKE :search"), 
			sequelize.literal("SqlQuery LIKE :search"), 
			sequelize.literal("UserID LIKE :search"), 
			sequelize.literal("ServerIP LIKE :search"), 
			sequelize.literal("RequestUrl LIKE :search"), 
			sequelize.literal("RequestData LIKE :search"), 
			sequelize.literal("RequestCompleted LIKE :search"), 
			sequelize.literal("RequestMsg LIKE :search"),
		];
	}

	
	
}
module.exports = App_Logs;
