
import Vue from 'vue';
import VueRouter from 'vue-router';
Vue.use(VueRouter)
let routes = [
	{
		name: 'main',
		path: '/',
		component: () => import('layouts/MainLayout.vue'),
		children: [
			//Dashboard routes


//sms routes
			{ 
				path: '/sms/', 
				name: 'smslist', 
				component: () => import('pages/sms/list.vue'), 
				props: true
			},
			{ 
				path: '/sms/(list|index)/:fieldName?/:fieldValue?', 
				name: 'smslistfilter', 
				component: () => import('pages/sms/list.vue'), 
				props: true
			},
	
			{ 
				path: '/sms/view/:id', 
				name: 'smsview', 
				component: () => import('pages/sms/view.vue'), 
				props: true
			},
	
			{ 
				path: '/sms/add', 
				name: 'smsadd', 
				component: () => import('pages/sms/add.vue'), 
				props: true
			},
	
			{ 
				path: '/sms/edit/:id', 
				name: 'smsedit', 
				component: () => import('pages/sms/edit.vue'), 
				props: true
			},
		

//grupos routes
			{ 
				path: '/grupos/', 
				name: 'gruposlist', 
				component: () => import('pages/grupos/list.vue'), 
				props: true
			},
			{ 
				path: '/grupos/(list|index)/:fieldName?/:fieldValue?', 
				name: 'gruposlistfilter', 
				component: () => import('pages/grupos/list.vue'), 
				props: true
			},
	
			{ 
				path: '/grupos/view/:id', 
				name: 'gruposview', 
				component: () => import('pages/grupos/view.vue'), 
				props: true
			},
	
			{ 
				path: '/grupos/add', 
				name: 'gruposadd', 
				component: () => import('pages/grupos/add.vue'), 
				props: true
			},
	
			{ 
				path: '/grupos/edit/:id', 
				name: 'gruposedit', 
				component: () => import('pages/grupos/edit.vue'), 
				props: true
			},
		

//contacto routes
			{ 
				path: '/contacto/', 
				name: 'contactolist', 
				component: () => import('pages/contacto/list.vue'), 
				props: true
			},
			{ 
				path: '/contacto/(list|index)/:fieldName?/:fieldValue?', 
				name: 'contactolistfilter', 
				component: () => import('pages/contacto/list.vue'), 
				props: true
			},
	
			{ 
				path: '/contacto/view/:id', 
				name: 'contactoview', 
				component: () => import('pages/contacto/view.vue'), 
				props: true
			},
	
			{ 
				path: '/contacto/add', 
				name: 'contactoadd', 
				component: () => import('pages/contacto/add.vue'), 
				props: true
			},
	
			{ 
				path: '/contacto/edit/:id', 
				name: 'contactoedit', 
				component: () => import('pages/contacto/edit.vue'), 
				props: true
			},
		

//user routes
			{ 
				path: '/user/', 
				name: 'userlist', 
				component: () => import('pages/user/list.vue'), 
				props: true
			},
			{ 
				path: '/user/(list|index)/:fieldName?/:fieldValue?', 
				name: 'userlistfilter', 
				component: () => import('pages/user/list.vue'), 
				props: true
			},
	
			{ 
				path: '/user/view/:id', 
				name: 'userview', 
				component: () => import('pages/user/view.vue'), 
				props: true
			},
	
			{ 
				path: '/index/register', 
				name: 'useruserregister', 
				component: () => import('pages/index/userregister.vue'), 
				props: true
			},
	
			{ 
				path: '/account/edit', 
				name: 'useraccountedit', 
				component: () => import('pages/account/accountedit.vue'), 
				props: true
			},
	
			{ 
				path: '/account', 
				name: 'useraccountview', 
				component: () => import('pages/account/accountview.vue'), 
				props: true
			},
	
			{ 
				path: '/user/add', 
				name: 'useradd', 
				component: () => import('pages/user/add.vue'), 
				props: true
			},
	
			{ 
				path: '/user/edit/:id', 
				name: 'useredit', 
				component: () => import('pages/user/edit.vue'), 
				props: true
			},
		

//roles routes
			{ 
				path: '/roles/', 
				name: 'roleslist', 
				component: () => import('pages/roles/list.vue'), 
				props: true
			},
			{ 
				path: '/roles/(list|index)/:fieldName?/:fieldValue?', 
				name: 'roleslistfilter', 
				component: () => import('pages/roles/list.vue'), 
				props: true
			},
	
			{ 
				path: '/roles/view/:id', 
				name: 'rolesview', 
				component: () => import('pages/roles/view.vue'), 
				props: true
			},
	
			{ 
				path: '/roles/add', 
				name: 'rolesadd', 
				component: () => import('pages/roles/add.vue'), 
				props: true
			},
	
			{ 
				path: '/roles/edit/:id', 
				name: 'rolesedit', 
				component: () => import('pages/roles/edit.vue'), 
				props: true
			},
		

//permissions routes
			{ 
				path: '/permissions/', 
				name: 'permissionslist', 
				component: () => import('pages/permissions/list.vue'), 
				props: true
			},
			{ 
				path: '/permissions/(list|index)/:fieldName?/:fieldValue?', 
				name: 'permissionslistfilter', 
				component: () => import('pages/permissions/list.vue'), 
				props: true
			},
	
			{ 
				path: '/permissions/view/:id', 
				name: 'permissionsview', 
				component: () => import('pages/permissions/view.vue'), 
				props: true
			},
	
			{ 
				path: '/permissions/add', 
				name: 'permissionsadd', 
				component: () => import('pages/permissions/add.vue'), 
				props: true
			},
	
			{ 
				path: '/permissions/edit/:id', 
				name: 'permissionsedit', 
				component: () => import('pages/permissions/edit.vue'), 
				props: true
			},
		

			
			
//Password reset routes
			{ 
				path: '/index/forgotpassword', 
				name: 'forgotpassword', 
				component: () => import('pages/index/forgotpassword.vue'), 
				props: true
			},
			{ 
				path: '/index/resetpassword', 
				name: 'resetpassword', 
				component: () => import('pages/index/resetpassword.vue'), 
				props: true
			},
			{ 
				path: '/index/resetpassword_completed', 
				name: 'resetpassword_completed', 
				component: () => import('pages/index/resetpassword_completed.vue'), 
				props: true
			},
	
			
			
			{ 
				path:  '/error/forbidden', 
				name: 'forbidden', 
				component: () => import('pages/errors/forbidden.vue'),
				props: true
			},
			{ 
				path: '/error/notfound', 
				name: 'notfound',
				component: () => import('pages/errors/pagenotfound.vue'),
				props: true
			}
		]
	},
];


/*
 * If not building with SSR mode, you can
 * directly export the Router instantiation;
 *
 * The function below can be async too; either use
 * async/await or return a Promise which resolves
 * with the Router instance.
 */

export default async function ({ store, ssrContext }) {
	let mainRoute = routes.find(x => x.name = "main");

	
	let loginToken = store.getters["auth/getLoginToken"];
	if(loginToken){
		try{
			await store.dispatch('auth/getUserData'); //get current user data from api on page load

			mainRoute.children.push({ 
				path: '/(home)?', 
				name: 'home', 
				component: () => import('pages/home/home.vue'),
				props: true
			});
		}
		catch(e){
			/*
			 * getting current user detail failed
			 * token must be invalid
			*/
			mainRoute.children.push({ 
				path: '/(index)?', 
				name: 'index', 
				component: () => import('pages/index/index.vue') ,
				props: true
			});
		}
	}
	else{
		/*
		 * user has not loggedIn
		 * show login page
		*/
		mainRoute.children.push({ path: '/(index|home)?', name: 'index', component: () => import('pages/index/index.vue') });
	}


	// Always leave this as last one
	if (process.env.MODE !== 'ssr') {
		mainRoute.children.push({path: '*', component: () => import('pages/errors/pagenotfound.vue')});
	}

	const Router = new VueRouter({
		scrollBehavior: () => ({ x: 0, y: 0 }),
		routes,
		// Leave these as they are and change in quasar.conf.js instead!
		// quasar.conf.js -> build -> vueRouterMode
		// quasar.conf.js -> build -> publicPath
		mode: process.env.VUE_ROUTER_MODE,
		base: process.env.VUE_ROUTER_BASE
	});
	return Router
}
