"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _os = _interopRequireDefault(require("os"));

var _cacache = _interopRequireDefault(require("cacache"));

var _findCacheDir = _interopRequireDefault(require("find-cache-dir"));

var _serializeJavascript = _interopRequireDefault(require("serialize-javascript"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class Webpack4Cache {
  constructor(compilation, options, weakCache) {
    this.cache = options.cache === true ? Webpack4Cache.getCacheDirectory() : options.cache;
    this.weakCache = weakCache;
  }

  static getCacheDirectory() {
    return (0, _findCacheDir.default)({
      name: 'compression-webpack-plugin'
    }) || _os.default.tmpdir();
  }

  async get(task, sources) {
    const weakOutput = this.weakCache.get(task.assetSource);

    if (weakOutput) {
      return weakOutput;
    }

    if (!this.cache) {
      // eslint-disable-next-line no-undefined
      return undefined;
    } // eslint-disable-next-line no-param-reassign


    task.cacheIdent = task.cacheIdent || (0, _serializeJavascript.default)(task.cacheKeys);
    let cachedResult;

    try {
      cachedResult = await _cacache.default.get(this.cache, task.cacheIdent);
    } catch (ignoreError) {
      // eslint-disable-next-line no-undefined
      return undefined;
    }

    return new sources.RawSource(Buffer.from(JSON.parse(cachedResult.data).data));
  }

  async store(task) {
    if (!this.weakCache.has(task.assetSource)) {
      this.weakCache.set(task.assetSource, task.output);
    }

    if (!this.cache) {
      // eslint-disable-next-line no-undefined
      return undefined;
    }

    const {
      cacheIdent,
      output
    } = task;
    return _cacache.default.put(this.cache, cacheIdent, JSON.stringify(output.source()));
  }

}

exports.default = Webpack4Cache;