/*!
 * @quasar/quasar-ui-qcalendar v3.4.0
 * (c) 2021 Jeff Galbraith <jeff@quasar.dev>
 * Released under the MIT License.
 */
"use strict";var quasar=require("quasar"),version="3.4.0",PARSE_REGEX=/^(\d{4})-(\d{1,2})(-(\d{1,2}))?([^\d]+(\d{1,2}))?(:(\d{1,2}))?(:(\d{1,2}))?(.(\d{1,3}))?$/,PARSE_TIME=/(\d\d?)(:(\d\d?)|)(:(\d\d?)|)/,DAYS_IN_MONTH=[0,31,28,31,30,31,30,31,31,30,31,30,31],DAYS_IN_MONTH_LEAP=[0,31,29,31,30,31,30,31,31,30,31,30,31],DAYS_IN_MONTH_MIN=28,DAYS_IN_MONTH_MAX=31,MONTH_MAX=12,MONTH_MIN=1,DAY_MIN=1,DAYS_IN_WEEK=7,MINUTES_IN_HOUR=60,HOURS_IN_DAY=24,FIRST_HOUR=0,MILLISECONDS_IN_MINUTE=6e4,MILLISECONDS_IN_HOUR=36e5,MILLISECONDS_IN_DAY=864e5,MILLISECONDS_IN_WEEK=6048e5,Timestamp={date:"",time:"",year:0,month:0,day:0,weekday:0,hour:0,minute:0,doy:0,workweek:0,hasDay:!1,hasTime:!1,past:!1,current:!1,future:!1,disabled:!1},TimeObject={hour:0,minute:0};function today(){var e=new Date,t=""+(e.getMonth()+1),a=""+e.getDate();return[e.getFullYear(),padNumber(t,2),padNumber(a,2)].join("-")}function getStartOfWeek(e,t,a){var r=copyTimestamp(e);if(1===r.day||0===r.weekday)for(;!t.includes(r.weekday);)r=nextDay(r);return r=updateFormatted(r=findWeekday(r,t[0],prevDay)),a&&(r=updateRelative(r,a,r.hasTime)),r}function getEndOfWeek(e,t,a){var r=copyTimestamp(e);if(daysInMonth(r.year,r.month)===r.day||6===r.weekday)for(;!t.includes(r.weekday);)r=prevDay(r);return r=updateFormatted(r=findWeekday(r,t[t.length-1],nextDay)),a&&(r=updateRelative(r,a,r.hasTime)),r}function getStartOfMonth(e){var t=copyTimestamp(e);return t.day=DAY_MIN,updateFormatted(t),t}function getEndOfMonth(e){var t=copyTimestamp(e);return t.day=daysInMonth(t.year,t.month),updateFormatted(t),t}function parseTime(e){switch(Object.prototype.toString.call(e)){case"[object Number]":return e;case"[object String]":var t=PARSE_TIME.exec(e);return!!t&&60*parseInt(t[1],10)+parseInt(t[3]||0,10);case"[object Object]":return"number"==typeof e.hour&&"number"==typeof e.minute&&60*e.hour+e.minute}return!1}function validateTimestamp(e){return!!PARSE_REGEX.exec(e)}function compareTimestamps(e,t){return JSON.stringify(e)===JSON.stringify(t)}function compareDate(e,t){return getDate(e)===getDate(t)}function compareTime(e,t){return getTime(e)===getTime(t)}function compareDateTime(e,t){return getDateTime(e)===getDateTime(t)}function parsed(e){var t=PARSE_REGEX.exec(e);return t?{date:e,time:padNumber(parseInt(t[6],10)||0,2)+":"+padNumber(parseInt(t[8],10)||0,2),year:parseInt(t[1],10),month:parseInt(t[2],10),day:parseInt(t[4],10)||1,hour:parseInt(t[6],10)||0,minute:parseInt(t[8],10)||0,weekday:0,doy:0,workweek:0,hasDay:!!t[4],hasTime:!(!t[6]||!t[8]),past:!1,current:!1,future:!1,disabled:!1}:null}function parseTimestamp(e,t){var a=parsed(e);return null===a?null:(a=updateFormatted(a),t&&updateRelative(a,t,a.hasTime),a)}function parseDate(e){return updateFormatted({date:padNumber(e.getFullYear(),4)+"-"+padNumber(e.getMonth()+1,2)+"-"+padNumber(e.getDate(),2),time:padNumber(e.getHours()||0,2)+":"+padNumber(e.getMinutes()||0,2),year:e.getFullYear(),month:e.getMonth()+1,day:e.getDate(),hour:e.getHours(),minute:e.getMinutes(),weekday:0,doy:0,workweek:0,hasDay:!0,hasTime:!(0===e.getHours()||0===e.getMinutes()),past:!1,current:!1,future:!1,disabled:!1})}function getDayIdentifier(e){return 1e8*e.year+1e6*e.month+1e4*e.day}function getTimeIdentifier(e){return 100*e.hour+e.minute}function getDayTimeIdentifier(e){return getDayIdentifier(e)+getTimeIdentifier(e)}function diffTimestamp(e,t,a){var r=Date.UTC(e.year,e.month-1,e.day,e.hour,e.minute),n=Date.UTC(t.year,t.month-1,t.day,t.hour,t.minute);return!0===a&&n<r?0:n-r}function updateRelative(e,t,a){void 0===a&&(a=!1);var r=getDayIdentifier(t),n=getDayIdentifier(e),i=r===n;return e.hasTime&&a&&i&&(i=(r=getTimeIdentifier(t))===(n=getTimeIdentifier(e))),e.past=n<r,e.current=i,e.future=n>r,e}function updateMinutes(e,t,a){return e.hasTime=!0,e.hour=Math.floor(t/MINUTES_IN_HOUR),e.minute=t%MINUTES_IN_HOUR,e.time=getTime(e),a&&updateRelative(e,a,!0),e}function updateWeekday(e){return e.weekday=getWeekday(e),e}function updateDayOfYear(e){return e.doy=getDayOfYear(e),e}function updateWorkWeek(e){return e.workweek=getWorkWeek(e),e}function updateDisabled(e,t,a,r,n){var i=getDayIdentifier(e);void 0!==t&&(i<=getDayIdentifier(parsed(t))&&(e.disabled=!0));!0!==e.disabled&&void 0!==a&&(i>=getDayIdentifier(parsed(a))&&(e.disabled=!0));if(!0!==e.disabled&&Array.isArray(r)&&r.length>0)for(var s in r)if(r[s]===e.weekday){e.disabled=!0;break}if(!0!==e.disabled&&Array.isArray(n)&&n.length>0)for(var d in n){if(Array.isArray(n[d])&&2===n[d].length){if(isBetweenDates(e,parsed(n[d][0]),parsed(n[d][1]))){e.disabled=!0;break}}else if(getDayIdentifier(parseTimestamp(n[d]+" 00:00"))===i){e.disabled=!0;break}}return e}function updateFormatted(e){return e.hasTime=!(0===e.hour&&0===e.minute),e.time=getTime(e),e.date=getDate(e),e.weekday=getWeekday(e),e.doy=getDayOfYear(e),e.workweek=getWorkWeek(e),e}function getDayOfYear(e){if(0!==e.year)return(Date.UTC(e.year,e.month-1,e.day)-Date.UTC(e.year,0,0))/24/60/60/1e3}function getWorkWeek(e){var t;if(t=0===e.year?Date.UTC(new Date):makeDate(e),isNaN(t))return 0;var a=new Date(t.getFullYear(),t.getMonth(),t.getDate());a.setDate(a.getDate()-(a.getDay()+6)%7+3);var r=new Date(a.getFullYear(),0,4);r.setDate(r.getDate()-(r.getDay()+6)%7+3);var n=a.getTimezoneOffset()-r.getTimezoneOffset();a.setHours(a.getHours()-n);var i=(a-r)/MILLISECONDS_IN_WEEK;return 1+Math.floor(i)}function getWeekday(e){var t=e.weekday;if(e.hasDay){var a=Math.floor,r=e.day,n=(e.month+9)%MONTH_MAX+1,i=a(e.year/100),s=e.year%100-(e.month<=2?1:0);t=((r+a(2.6*n-.2)-2*i+s+a(s/4)+a(i/4))%7+7)%7}return t}function isLeapYear(e){return 1==(e%4==0^e%100==0^e%400==0)}function daysInMonth(e,t){return isLeapYear(e)?DAYS_IN_MONTH_LEAP[t]:DAYS_IN_MONTH[t]}function copyTimestamp(e){return Object.assign({},e)}function padNumber(e,t){for(var a=String(e);a.length<t;)a="0"+a;return a}function getDate(e){var t=padNumber(e.year,4)+"-"+padNumber(e.month,2);return e.hasDay&&(t+="-"+padNumber(e.day,2)),t}function getTime(e){return e.hasTime?padNumber(e.hour,2)+":"+padNumber(e.minute,2):""}function getDateTime(e){return getDate(e)+" "+(e.hasTime?getTime(e):"00:00")}function nextDay(e){return++e.day,e.weekday=(e.weekday+1)%DAYS_IN_WEEK,e.day>DAYS_IN_MONTH_MIN&&e.day>daysInMonth(e.year,e.month)&&(e.day=DAY_MIN,++e.month,e.month>MONTH_MAX&&(e.month=MONTH_MIN,++e.year)),e}function prevDay(e){return e.day--,e.weekday=(e.weekday+6)%DAYS_IN_WEEK,e.day<DAY_MIN&&(e.month--,e.month<MONTH_MIN&&(e.year--,e.month=MONTH_MAX),e.day=daysInMonth(e.year,e.month)),e}function moveRelativeDays(e,t,a,r){return void 0===t&&(t=nextDay),void 0===a&&(a=1),void 0===r&&(r=[0,1,2,3,4,5,6]),relativeDays(e,t,a,r)}function relativeDays(e,t,a,r){for(void 0===t&&(t=nextDay),void 0===a&&(a=1),void 0===r&&(r=[0,1,2,3,4,5,6]);--a>=0;)e=t(e),r.length<7&&!r.includes(e.weekday)&&++a;return e}function findWeekday(e,t,a,r){for(void 0===a&&(a=nextDay),void 0===r&&(r=6);e.weekday!==t&&--r>=0;)e=a(e);return e}function getWeekdaySkips(e){for(var t=[1,1,1,1,1,1,1],a=[0,0,0,0,0,0,0],r=0;r<e.length;++r)a[e[r]]=1;for(var n=0;n<DAYS_IN_WEEK;++n){for(var i=1,s=1;s<DAYS_IN_WEEK;++s){if(a[(n+s)%DAYS_IN_WEEK])break;++i}t[n]=a[n]*i}return t}function createDayList(e,t,a,r,n,i,s,d,o,u){void 0===s&&(s=[]),void 0===d&&(d=[]),void 0===o&&(o=42),void 0===u&&(u=0);var l=getDayIdentifier(t),c=[],h=copyTimestamp(e),m=0,y=m===l;if(l<getDayIdentifier(e))return c;for(;(!y||c.length<u)&&c.length<o&&(m=getDayIdentifier(h),!(y=y||m>l&&c.length>=u));)if(0!==r[h.weekday]){var v=copyTimestamp(h);updateFormatted(v),updateRelative(v,a),updateDisabled(v,n,i,s,d),c.push(v),h=relativeDays(h,nextDay)}else h=nextDay(h);return c}function createIntervalList(e,t,a,r,n){for(var i=[],s=0;s<r;++s){var d=(t+s)*a,o=copyTimestamp(e);i.push(updateMinutes(o,d,n))}return i}function createNativeLocaleFormatter(e,t){return"undefined"==typeof Intl||void 0===Intl.DateTimeFormat?function(e,t){return""}:function(a,r){try{return new Intl.DateTimeFormat(e||void 0,t(a,r)).format(makeDateTime(a))}catch(e){return console.error("Intl.DateTimeFormat: "+e.message+" -> "+getDateTime(a)),""}}}function makeDate(e){return new Date(Date.UTC(e.year,e.month-1,e.day,0,0))}function makeDateTime(e){return new Date(Date.UTC(e.year,e.month-1,e.day,e.hour,e.minute))}function validateNumber(e){return isFinite(parseInt(e,10))}function isBetweenDates(e,t,a,r){var n=getDayIdentifier(e)+(!0===r?getTimeIdentifier(e):0),i=getDayIdentifier(t)+(!0===r?getTimeIdentifier(t):0),s=getDayIdentifier(a)+(!0===r?getTimeIdentifier(a):0);return n>=i&&n<=s}function isOverlappingDates(e,t,a,r){var n=getDayIdentifier(e),i=getDayIdentifier(t),s=getDayIdentifier(a),d=getDayIdentifier(r);return n>=s&&n<=d||i>=s&&i<=d||s>=n&&i>=d}function addToDate(e,t){var a,r=copyTimestamp(e);return __forEachObject(t,function(e,t){if(void 0!==r[t]){r[t]+=parseInt(e,10);var n=NORMALIZE_TYPES.indexOf(t);-1!==n&&(a=void 0===a?n:Math.min(n,a))}}),void 0!==a&&__normalize(r,NORMALIZE_TYPES[a]),updateFormatted(r),r}var NORMALIZE_TYPES=["minute","hour","day","month"];function __forEachObject(e,t){Object.keys(e).forEach(function(a){return t(e[a],a)})}function __normalizeMinute(e){if(e.minute>=MINUTES_IN_HOUR||e.minute<0){var t=Math.floor(e.minute/MINUTES_IN_HOUR);e.minute-=t*MINUTES_IN_HOUR,e.hour+=t,__normalizeHour(e)}return e}function __normalizeHour(e){if(e.hour>=HOURS_IN_DAY||e.hour<0){var t=Math.floor(e.hour/HOURS_IN_DAY);e.hour-=t*HOURS_IN_DAY,e.day+=t,__normalizeDay(e)}return e}function __normalizeDay(e){__normalizeMonth(e);var t=daysInMonth(e.year,e.month);if(e.day>t){++e.month,e.month>MONTH_MAX&&__normalizeMonth(e);var a=e.day-t;t=daysInMonth(e.year,e.month);do{a>t&&(++e.month,e.month>MONTH_MAX&&__normalizeMonth(e),a-=t,t=daysInMonth(e.year,e.month))}while(a>t);e.day=a}else if(e.day<=0){var r=-1*e.day;--e.month,e.month<=0&&__normalizeMonth(e),t=daysInMonth(e.year,e.month);do{r>t&&(r-=t,--e.month,e.month<=0&&__normalizeMonth(e),t=daysInMonth(e.year,e.month))}while(r>t);e.day=t-r}return e}function __normalizeMonth(e){if(e.month>MONTH_MAX){var t=Math.floor(e.month/MONTH_MAX);e.month=e.month%MONTH_MAX,e.year+=t}else e.month<MONTH_MIN&&(e.month+=MONTH_MAX,--e.year);return e}function __normalize(e,t){switch(t){case"minute":return __normalizeMinute(e);case"hour":return __normalizeHour(e);case"day":return __normalizeDay(e);case"month":return __normalizeMonth(e)}}function daysBetween(e,t){var a=diffTimestamp(e,t,!0);return Math.floor(a/MILLISECONDS_IN_DAY)}function weeksBetween(e,t){var a=copyTimestamp(e),r=copyTimestamp(t);return a=findWeekday(a,0),r=findWeekday(r,6),Math.ceil(daysBetween(a,r)/DAYS_IN_WEEK)}var Times={name:"Times",props:{now:{type:String,validator:function(e){return""===e||validateTimestamp(e)},default:""}},data:function(){return{times:{now:parseTimestamp("0000-00-00 00:00"),today:parseTimestamp("0000-00-00")}}},computed:{parsedNow:function(){return this.now?parseTimestamp(this.now):this.getNow()}},watch:{parsedNow:"updateCurrent"},beforeMount:function(){this.updateCurrent(),this.setCurrent()},methods:{setCurrent:function(){this.times.now.current=this.times.today.current=!0,this.times.now.past=this.times.today.past=!1,this.times.now.future=this.times.today.future=!1},updateCurrent:function(){var e=this.parsedNow||this.getNow();this.updateDay(e,this.times.now),this.updateTime(e,this.times.now),this.updateDay(e,this.times.today)},getNow:function(){return parseDate(new Date)},updateDay:function(e,t){e.date!==t.date&&(t.year=e.year,t.month=e.month,t.day=e.day,t.weekday=e.weekday,t.date=e.date)},updateTime:function(e,t){e.time!==t.time&&(t.hour=e.hour,t.minute=e.minute,t.time=e.time)}}},Mouse={name:"Mouse",methods:{getDefaultMouseEventWithSuffix:function(e){var t;return(t={})["click"+e]={event:"click"},t["contextmenu"+e]={event:"contextmenu",prevent:!0,result:!1},t["mousedown"+e]={event:"mousedown"},t["mousemove"+e]={event:"mousemove"},t["mouseup"+e]={event:"mouseup"},t["mouseenter"+e]={event:"mouseenter"},t["mouseleave"+e]={event:"mouseleave"},t["touchstart"+e]={event:"touchstart"},t["touchmove"+e]={event:"touchmove"},t["touchend"+e]={event:"touchend"},t},getDefaultMouseEventHandlers2:function(e,t,a){var r;return this.getMouseEventHandlers(((r={})["click"+e]={event:"click"},r["contextmenu"+e]={event:"contextmenu",prevent:!0,result:!1},r["mousedown"+e]={event:"mousedown"},r["mousemove"+e]={event:"mousemove"},r["mouseup"+e]={event:"mouseup"},r["mouseenter"+e]={event:"mouseenter"},r["mouseleave"+e]={event:"mouseleave"},r["touchstart"+e]={event:"touchstart"},r["touchmove"+e]={event:"touchmove"},r["touchend"+e]={event:"touchend"},r["click"+t]={event:"click"},r["contextmenu"+t]={event:"contextmenu",prevent:!0,result:!1},r["mousedown"+t]={event:"mousedown"},r["mousemove"+t]={event:"mousemove"},r["mouseup"+t]={event:"mouseup"},r["mouseenter"+t]={event:"mouseenter"},r["mouseleave"+t]={event:"mouseleave"},r["touchstart"+t]={event:"touchstart"},r["touchmove"+t]={event:"touchmove"},r["touchend"+t]={event:"touchend"},r),a)},getDefaultMouseEventHandlers:function(e,t){var a;return this.getMouseEventHandlers(((a={})["click"+e]={event:"click"},a["contextmenu"+e]={event:"contextmenu",prevent:!0,result:!1},a["mousedown"+e]={event:"mousedown"},a["mousemove"+e]={event:"mousemove"},a["mouseup"+e]={event:"mouseup"},a["mouseenter"+e]={event:"mouseenter"},a["mouseleave"+e]={event:"mouseleave"},a["touchstart"+e]={event:"touchstart"},a["touchmove"+e]={event:"touchmove"},a["touchend"+e]={event:"touchend"},a),t)},getMouseEventHandlers:function(e,t){var a=this,r={},n=function(n){var i=e[n];if(a.$listeners[n]){var s=(i.passive?"&":(i.once?"~":"")+(i.capture?"!":""))+i.event,d=function(e){var r=e;return(void 0===i.button||r.buttons>0&&r.button===i.button)&&(i.prevent&&r.preventDefault(),i.stop&&r.stopPropagation(),a.$emit(n,t(r,n))),i.result};s in r?Array.isArray(r[s])?r[s].push(d):r[s]=[r[s],d]:r[s]=d}};for(var i in e)n(i);return r}}};function validateView(e){return["month","week","day","2day","3day","4day","5day","6day","month-scheduler","week-scheduler","custom-scheduler","scheduler","day-scheduler","2day-scheduler","3day-scheduler","4day-scheduler","5day-scheduler","6day-scheduler","resource","day-resource","month-agenda","week-agenda","custom-agenda","agenda","day-agenda","2day-agenda","3day-agenda","4day-agenda","5day-agenda","6day-agenda","month-interval","custom-interval"].includes(e)}var props={base:{value:{type:String,validator:function(e){return""===e||validateTimestamp(e)}},weekdays:{type:Array,default:function(){return[0,1,2,3,4,5,6]}},noActiveDate:Boolean,disabledDays:Array,disabledBefore:String,disabledAfter:String,disabledWeekdays:{type:Array,default:function(){return[]}},hideHeader:Boolean,noScroll:Boolean,shortWeekdayLabel:Boolean,noDefaultHeaderText:Boolean,noDefaultHeaderBtn:Boolean,locale:{type:String,default:"en-us"},animated:Boolean,transitionPrev:{type:String,default:"slide-right"},transitionNext:{type:String,default:"slide-left"},dragOverFunc:{type:Function},dropFunc:{type:Function},selectedDates:Array,selectedStartEndDates:{type:Array,default:function(){return[]},validator:function(e){return e.length<=2}}},intervals:{maxDays:{type:Number,default:7},shortIntervalLabel:Boolean,intervalHeight:{type:[Number,String],default:40,validator:validateNumber},intervalMinutes:{type:[Number,String],default:60,validator:validateNumber},intervalStart:{type:[Number,String],default:0,validator:validateNumber},intervalCount:{type:[Number,String],default:24,validator:validateNumber},intervalStyle:{type:Function,default:null},showIntervalLabel:{type:Function,default:null},hour24Format:Boolean,columnHeaderBefore:Boolean,columnHeaderAfter:Boolean,columnCount:{type:[Number,String],default:1,validator:validateNumber},columnIndexStart:{type:[Number,String],default:0,validator:validateNumber},timeClicksClamped:Boolean},weeks:{dayHeight:{type:[Number,String],default:0,validator:validateNumber},dayStyle:{type:Function,default:null},dayClass:{type:Function,default:null},dayPadding:String,minWeeks:{type:[Number,String],validator:validateNumber,default:1},shortMonthLabel:Boolean,showWorkWeeks:Boolean,showMonthLabel:{type:Boolean,default:!0},showDayOfYearLabel:Boolean,enableOutsideDays:Boolean,hideOutsideDays:Boolean,hover:Boolean,miniMode:{type:[Boolean,String],validator:function(e){return void 0===e||!0===e||!1===e||"auto"===e}},breakpoint:{type:String,default:"md",validator:function(e){return["xs","sm","md","lg","xl"].includes(e)}},monthLabelSize:{type:String,default:"sm",validator:function(e){return["xs","sm","md","lg","xl"].includes(e)}}},scheduler:{resources:Array,resourceKey:{type:String,default:"label"},maxDays:{type:Number,default:7},resourceHeight:{type:[Number,String],default:70,validator:validateNumber},resourceWidth:{type:[Number,String],validator:function(e){return void 0===e||validateNumber(e)}},resourceStyle:{type:Function,default:null},cellWidth:String,columnHeaderBefore:Boolean,columnHeaderAfter:Boolean,columnCount:{type:[Number,String],default:1,validator:validateNumber},columnIndexStart:{type:[Number,String],default:0,validator:validateNumber}},resource:{resources:Array,resourceKey:{type:String,default:"label"},resourceHeight:{type:[Number,String],default:70,validator:validateNumber},resourceWidth:{type:[Number,String],default:100,validator:function(e){return void 0===e||validateNumber(e)}},resourceStyle:{type:Function,default:null},intervalWidth:{type:[Number,String],default:100,validator:validateNumber},intervalHeight:{type:[Number,String],default:20,validator:validateNumber},sticky:Boolean},agenda:{leftColumnOptions:Array,rightColumnOptions:Array,columnOptionsId:String,columnOptionsLabel:String},calendar:{view:{type:String,default:"month",validator:validateView},bordered:Boolean,dark:Boolean}},CalendarBase={name:"CalendarBase",mixins:[Mouse,Times],props:Object.assign({},props.base,{start:{type:String,validator:validateTimestamp,default:function(){return parseDate(new Date).date}},end:{type:String,validator:validateTimestamp,default:"0000-00-00"}}),data:function(){return{keyValue:0}},computed:{weekdaySkips:function(){return getWeekdaySkips(this.weekdays)},parsedStart:function(){return parseTimestamp(this.start)},parsedEnd:function(){return parseTimestamp(this.end)},days:function(){return createDayList(this.parsedStart,this.parsedEnd,this.times.today,this.weekdaySkips,this.disabledBefore,this.disabledAfter,this.disabledWeekdays,this.disabledDays)},dayFormatter:function(){var e={timeZone:"UTC",day:"numeric"};return createNativeLocaleFormatter(this.locale,function(t,a){return e})},weekdayFormatter:function(){var e={timeZone:"UTC",weekday:"long"},t={timeZone:"UTC",weekday:"short"};return createNativeLocaleFormatter(this.locale,function(a,r){return r?t:e})}},methods:{arrayHasDate:function(e,t){return e&&e.length>0&&e.includes(t.date)},arrayHasDateTime:function(e,t){return e&&e.length>0&&e.includes(getDateTime(t))},checkDays:function(e,t){var a={firstDay:!1,betweenDays:!1,lastDay:!1};if(e&&2===e.length){var r=getDayIdentifier(t),n=getDayIdentifier(parsed(e[0])),i=getDayIdentifier(parsed(e[1]));a.firstDay=n===r,a.lastDay=i===r,a.betweenDays=n<r&&i>r}return a},checkIntervals:function(e,t){var a={firstDay:!1,betweenDays:!1,lastDay:!1};if(e&&2===e.length){var r=getDayTimeIdentifier(t),n=getDayTimeIdentifier(parsed(e[0])),i=getDayTimeIdentifier(parsed(e[1]));a.firstDay=n===r,a.lastDay=i===r,a.betweenDays=n<r&&i>r}return a},getRelativeClasses:function(e,t,a,r,n){void 0===t&&(t=!1),void 0===a&&(a=[]),void 0===r&&(r=[]),void 0===n&&(n=!1);var i=this.arrayHasDate(a,e),s=this.checkDays(r,e),d=s.firstDay,o=s.lastDay,u=s.betweenDays;return{"q-past-day":!0!==d&&!0!==u&&!0!==o&&!0!==i&&!0!==t&&e.past,"q-future-day":!0!==d&&!0!==u&&!0!==o&&!0!==i&&!0!==t&&e.future,"q-outside":t,"q-current-day":e.current,"q-selected":i,"q-range-first":!0===d,"q-range":!0===u,"q-range-last":!0===o,"q-range-hover":!0===n&&(!0===d||!0===o||!0===u),"q-disabled-day disabled":!0===e.disabled}},getIntervalClasses:function(e,t,a){void 0===t&&(t=[]),void 0===a&&(a=[]);var r=this.arrayHasDateTime(t,e),n=this.checkIntervals(a,e),i=n.firstDay,s=n.lastDay;return{"q-selected":r,"q-range-first":!0===i,"q-range":!0===n.betweenDays,"q-range-last":!0===s,"q-disabled-interval disabled":!0===e.disabled}},getStartOfWeek:function(e){return getStartOfWeek(e,this.weekdays,this.times.today)},getEndOfWeek:function(e){return getEndOfWeek(e,this.weekdays,this.times.today)},dayStyleDefault:function(e){}}};function convertToUnit(e,t){return void 0===t&&(t="px"),null==e||""===e?void 0:isNaN(e)?String(e):"auto"===e?e:""+Number(e)+t}function indexOf(e,t){for(var a=0;a<e.length;a++)if(!0===t(e[a],a))return a;return-1}var QCalendarWeekly={name:"QCalendarWeekly",mixins:[CalendarBase],props:Object.assign({},props.weeks,{direction:{type:String,default:"next"}}),mounted:function(){this.__adjustForWeekEvents()},updated:function(){this.__adjustForWeekEvents()},computed:{staticClass:function(){return"q-calendar-weekly"},parsedMinWeeks:function(){return parseInt(this.minWeeks,10)},days:function(){var e=this.parsedMinWeeks*this.weekdays.length;return createDayList(this.getStartOfWeek(this.parsedStart),this.getEndOfWeek(this.parsedEnd),this.times.today,this.weekdaySkips,this.disabledBefore,this.disabledAfter,this.disabledWeekdays,this.disabledDays,Number.MAX_SAFE_INTEGER,e)},todayWeek:function(){var e=this.days[0];return createDayList(this.getStartOfWeek(e),this.getEndOfWeek(e),e,this.weekdaySkips,this.disabledBefore,this.disabledAfter,this.disabledWeekdays,this.disabledDays,this.weekdays.length,this.weekdays.length)},monthFormatter:function(){var e={timeZone:"UTC",month:"long"},t={timeZone:"UTC",month:"short"};return createNativeLocaleFormatter(this.locale,function(a,r){return r?t:e})},styles:function(){var e={};return void 0!==this.dayPadding&&(e.padding=this.dayPadding),e.minWidth=this.cellWidth+"%",e.maxWidth=e.minWidth,e},cellWidth:function(){return 100/this.weekdays.length},isMiniMode:function(){return!0===this.miniMode||"auto"===this.miniMode&&void 0!==this.breakpoint&&this.$q.screen.lt[this.breakpoint]}},watch:{isMinimode:function(e){"auto"===this.breakpoint&&this.$emit("mini-mode",e)}},methods:{isOutside:function(e){var t=getDayIdentifier(e);return t<getDayIdentifier(this.parsedStart)||t>getDayIdentifier(this.parsedEnd)},isCurrentWeek:function(e){for(var t=0;t<e.length;++t)if(!0===e[t].current)return{timestamp:e[t]};return{timestamp:!1}},__adjustForWeekEvents:function(){if(!0!==this.isMiniMode&&(0===this.dayHeight&&void 0!==this.$scopedSlots.week))for(var e=0;e<7;++e){var t=this.$refs["weekEvent"+e];if(void 0===t)return;var a=this.$refs["week"+e];if(void 0===a)return;var r=window.getComputedStyle(t),n=parseFloat(r.marginTop,10)+parseFloat(r.marginBottom,10);t.clientHeight+n>a.clientHeight&&(a.style.height=t.clientHeight+n+"px")}},__renderContainer:function(e){var t=e("div",{staticClass:"q-calendar-weekly__container"},[].concat(this.__renderWeeks(e)));return!0===this.animated?e("transition",{props:{name:"q-transition--"+("prev"===this.direction?this.transitionPrev:this.transitionNext),appear:!0}},[t]):t},__renderHead:function(e){return e("div",{staticClass:"q-calendar-weekly__head"},[e("div",{staticClass:"q-calendar-weekly__head--wrapper"},[!0===this.showWorkWeeks&&this.__renderWorkWeekHead(e),this.__renderHeadDays(e)])])},__renderWorkWeekHead:function(e){var t=this.$scopedSlots["workweek-header"],a={start:this.parsedStart,end:this.parsedEnd,miniMode:this.isMiniMode};return e("div",{staticClass:"q-calendar-weekly__head-workweek",on:this.getDefaultMouseEventHandlers(":workweek:header2",function(e){return{scope:a,event:e}})},t?t({scope:a}):"#")},__renderHeadDays:function(e){var t=this;return e("div",{staticClass:"q-calendar-weekly__head-weekdays",style:{minWidth:this.showWorkWeeks?!0===this.isMiniMode?"calc(100% - var(--calendar-mini-work-week-width))":"calc(100% - var(--calendar-work-week-width))":"100%"}},[].concat(this.todayWeek.map(function(a,r){return t.__renderHeadDay(e,a,r)})))},__renderHeadDay:function(e,t,a){var r=this.cellWidth+"%",n=this.$scopedSlots["head-day"],i=!!this.disabledWeekdays&&this.disabledWeekdays.includes(t.weekday),s=this.days.filter(function(e){return e.weekday===t.weekday}),d={timestamp:t,days:s,index:a,miniMode:this.isMiniMode};return e("div",{key:t.date,staticClass:"q-calendar-weekly__head-weekday"+(!0===i?" q-disabled-day disabled":""),style:{minWidth:r,maxWidth:r},on:this.getDefaultMouseEventHandlers(":day:header2",function(e){return{scope:d,event:e}})},[void 0===n&&this.__renderHeadDayLabel(e,t,this.shortWeekdayLabel||this.isMiniMode),void 0!==n&&n(d)])},__renderHeadDayLabel:function(e,t,a){var r=this.weekdayFormatter(t,a);return e("span",{staticClass:"ellipsis"},!0===this.isMiniMode&&!0===this.shortWeekdayLabel?r.charAt(0):r)},__renderWeeks:function(e){for(var t=this.days,a=this.weekdays.length,r=[],n=0;n<t.length;n+=a)r.push(this.__renderWeek(e,t.slice(n,n+a),n/a));return r},__renderWeek:function(e,t,a){var r=this,n=this.$scopedSlots.week,i={week:t,weekdays:this.weekdays,miniMode:this.isMiniMode},s={};return s.height=this.dayHeight>0?convertToUnit(this.dayHeight):"auto",e("div",{key:t[0].date,ref:"week"+a,staticClass:"q-calendar-weekly__week--wrapper",style:s},[!0===this.showWorkWeeks&&this.__renderWorkWeekGutter(e,t),e("div",{staticClass:"q-calendar-weekly__week",style:{width:this.showWorkWeeks?!0===this.isMiniMode?"calc(100% - var(--calendar-mini-work-week-width))":"calc(100% - var(--calendar-work-week-width))":"100%"}},[e("div",{staticClass:"q-calendar-weekly__week-days"},t.map(function(t){return r.__renderDay(e,t)})),!0!==this.isMiniMode&&void 0!==n?e("div",{ref:"weekEvent"+a,staticClass:"q-calendar-weekly__week-events"},n(i)):""])])},__renderWorkWeekGutter:function(e,t){var a=this.$scopedSlots.workweek,r=t.length>2?t[2]:t[0],n=this.isCurrentWeek(t).timestamp,i=Number(r.workweek).toLocaleString(this.locale),s={workweekLabel:i,week:t,miniMode:this.isMiniMode};return e("div",{key:r.workweek,staticClass:"q-calendar-weekly__workweek",class:this.getRelativeClasses(!1!==n?n:r,!1),on:this.getDefaultMouseEventHandlers(":workweek2",function(e){return{scope:s,event:e}})},a?a(s):i)},__renderDay:function(e,t){var a,r=this,n=this.dayStyle||this.dayStyleDefault,i=this.isOutside(t),s=!0!==this.noActiveDate&&this.value===t.date,d=this.$scopedSlots.day,o={outside:i,timestamp:t,miniMode:this.isMiniMode,activeDate:s},u=!1===i&&this.days.find(function(e){return e.month===t.month}).day===t.day&&!0===this.showMonthLabel,l=Object.assign(Object.assign({},this.styles),n(t)),c="function"==typeof this.dayClass?this.dayClass(t):null;return e("div",{key:t.date,staticClass:"q-calendar-weekly__day"+(!0!==this.isMiniMode?" column":""),class:Object.assign({},c,this.getRelativeClasses(t,i,this.selectedDates,this.selectedStartEndDates,this.hover),{"q-active-date":!0===s,disabled:!0!==this.enableOutsideDays&&!0===i,"q-calendar-weekly__day--droppable":a}),style:l,domProps:{ondragover:function(e){void 0!==r.dragOverFunc&&(a=r.dragOverFunc(e,t,"day"))},ondrop:function(e){void 0!==r.dropFunc&&r.dropFunc(e,t,"day")}},on:this.getDefaultMouseEventHandlers(":day2",function(e){return{scope:o,event:e}})},[this.__renderDayLabel(e,t),!0!==this.isMiniMode&&this.showDayOfYearLabel&&!u?this.__renderDayOfYearLabel(e,t):"",!0!==this.isMiniMode&&u?this.__renderDayMonth(e,t):"",e("div",{staticClass:"q-calendar-weekly__day--content full-width"+(!0===this.isMiniMode?" row justify-center items-center":"")},d?d(o):"")])},__renderDayLabel:function(e,t){var a=this.isOutside(t);if(!0!==a||!0!==this.hideOutsideDays){var r=this.dayFormatter(t,!1),n=this.$scopedSlots["day-label"],i=this.$scopedSlots["day-btn"],s=this.selectedDates&&this.selectedDates.length>0&&this.selectedDates.includes(t.date),d=!0!==this.noActiveDate&&this.value===t.date,o={dayLabel:r,timestamp:t,outside:a,activeDate:d,selectedDate:s,miniMode:this.isMiniMode};return i?i(o):e(quasar.QBtn,{staticClass:"q-calendar-weekly__day-label",props:{size:this.isMiniMode?"sm":this.monthLabelSize,unelevated:!0,round:!0,dense:!0,noCaps:!0,outline:!0===t.current,disable:!0===t.disabled||!0!==this.enableOutsideDays&&!0===a},style:{lineHeight:this.isMiniMode?"unset":"1.715em"},on:this.getDefaultMouseEventHandlers(":date2",function(e){return{scope:{timestamp:t},event:e}})},[n?n(o):r])}},__renderDayOfYearLabel:function(e,t){if(!0!==this.isOutside(t)||!0!==this.hideOutsideDays){var a=this.$scopedSlots["day-of-year"];return e("div",{staticClass:"q-calendar-weekly__day-month--day-of-year"},a?a({timestamp:t}):t.doy)}},__renderDayMonth:function(e,t){if(!0!==this.isOutside(t)||!0!==this.hideOutsideDays){var a=this.$scopedSlots["month-label"],r=this.monthFormatter(t,this.shortMonthLabel),n={monthLabel:r,timestamp:t,miniMode:this.isMiniMode};return e("div",{staticClass:"q-calendar-weekly__day-month ellipsis"},[a?a(n):!0!==this.isMiniMode?r:""])}}},render:function(e){return e("div",{class:this.staticClass,on:{dragstart:function(e){e.preventDefault()}}},[!this.hideHeader&&this.__renderHead(e),this.__renderContainer(e)])}},QCalendarMonthly={name:"QCalendarMonthly",mixins:[QCalendarWeekly],computed:{parsedStart:function(){return getStartOfMonth(parseTimestamp(this.start))},parsedEnd:function(){return getEndOfMonth(parseTimestamp(this.end))}}},Resize={name:"resize",inserted:function(e,t){var a=t.value,r=t.options||{passive:!0};window.addEventListener("resize",a,r),e._onResize={callback:a,options:r},t.modifiers&&t.modifiers.quiet||a()},unbind:function(e){if(e._onResize){var t=e._onResize,a=t.callback,r=t.options;window.removeEventListener("resize",a,r),delete e._onResize}}},CalendarIntervals={name:"CalendarWithIntervals",mixins:[CalendarBase],props:Object.assign({},props.intervals),computed:{parsedIntervalStart:function(){return parseInt(this.intervalStart,10)},parsedIntervalMinutes:function(){return parseInt(this.intervalMinutes,10)},parsedIntervalCount:function(){return parseInt(this.intervalCount,10)},parsedIntervalHeight:function(){return parseFloat(this.intervalHeight)},parsedIntervalWidth:function(){return parseFloat(this.intervalWidth)},startMinute:function(){return this.parsedIntervalStart*this.parsedIntervalMinutes},bodyHeight:function(){return this.parsedIntervalCount*this.parsedIntervalHeight},bodyWidth:function(){return this.parsedIntervalCount*this.parsedIntervalWidth},days:function(){return createDayList(this.parsedStart,this.parsedEnd,this.times.today,this.weekdaySkips,this.disabledBefore,this.disabledAfter,this.disabledWeekdays,this.disabledDays,this.maxDays)},intervals:function(){var e=this.days,t=this.parsedIntervalStart,a=this.parsedIntervalMinutes,r=this.parsedIntervalCount,n=this.times.now;return 0===e.length&&console.error("QCalendar: days array has no content"),e.map(function(e){return createIntervalList(e,t,a,r,n)})},intervalFormatter:function(){var e={timeZone:"UTC",hour12:!this.hour24Format,hour:"2-digit",minute:"2-digit"},t={timeZone:"UTC",hour12:!this.hour24Format,hour:"numeric",minute:"2-digit"},a={timeZone:"UTC",hour12:!this.hour24Format,hour:"numeric"};return createNativeLocaleFormatter(this.locale,function(r,n){return n?0===r.minute?a:t:e})}},methods:{showIntervalLabelDefault:function(e){var t=this.intervals[0][0];return!(t.hour===e.hour&&t.minute===e.minute)&&0===e.minute},intervalStyleDefault:function(e){},getTimestampAtEvent:function(e,t,a){void 0===a&&(a=!1);var r=copyTimestamp(t),n=e.currentTarget.getBoundingClientRect(),i=this.startMinute,s=e,d=e,o=s.changedTouches||s.touches,u=((o&&o[0]?o[0].clientY:d.clientY)-n.top)/this.parsedIntervalHeight;return updateMinutes(r,i+Math.floor((a?Math.floor(u):u)*this.parsedIntervalMinutes),this.times.now)},getTimestampAtEventX:function(e,t,a){void 0===a&&(a=!1);var r=copyTimestamp(t),n=e.currentTarget.getBoundingClientRect(),i=e,s=e,d=i.changedTouches||i.touches,o=((d&&d[0]?d[0].clientX:s.clientX)-n.left)/this.parsedIntervalWidth;return updateMinutes(r,Math.floor((a?Math.floor(o):o)*this.parsedIntervalMinutes)+(60*t.hour+t.minute),this.times.now)},getScopeForSlot:function(e,t){var a={timestamp:copyTimestamp(e)};return a.timeStartPos=this.timeStartPos,a.timeDurationHeight=this.timeDurationHeight,void 0!==t&&(a.index=t),a},getScopeForSlotX:function(e,t){var a={timestamp:copyTimestamp(e)};return a.timeStartPosX=this.timeStartPosX,a.timeDurationWidth=this.timeDurationWidth,void 0!==t&&(a.index=t),a},scrollToTime:function(e){var t=this.timeStartPos(e),a=this.$refs.scrollArea;return!(!1===t||!a)&&(a.scrollTop=t,!0)},scrollToTimeX:function(e){var t=this.timeStartPosX(e),a=this.$refs.scrollArea;return!(!1===t||!a)&&(a.scrollLeft=t,!0)},timeDurationHeight:function(e){return e/this.parsedIntervalMinutes*this.parsedIntervalHeight},timeDurationWidth:function(e){return e/this.parsedIntervalMinutes*this.parsedIntervalWidth},heightToMinutes:function(e){return parseInt(e,10)*this.parsedIntervalMinutes/this.parsedIntervalHeight},widthToMinutes:function(e){return parseInt(e,10)*this.parsedIntervalMinutes/this.parsedCellWidth},timeStartPos:function(e,t){void 0===t&&(t=!0);var a=parseTime(e);if(!1===a)return!1;var r=(a-this.startMinute)/(this.parsedIntervalCount*this.parsedIntervalMinutes)*this.bodyHeight;return t&&(r<0&&(r=0),r>this.bodyHeight&&(r=this.bodyHeight)),r},timeStartPosX:function(e,t){void 0===t&&(t=!0);var a=parseTime(e);if(!1===a)return!1;var r=(a-this.startMinute)/(this.parsedIntervalCount*this.parsedIntervalMinutes)*this.bodyWidth;return t&&(r<0&&(r=0),r>this.bodyWidth&&(r=this.bodyWidth)),r}}},QCalendarDaily={name:"QCalendarDaily",mixins:[CalendarIntervals],props:{direction:{type:String,default:"next"}},directives:{Resize:Resize},data:function(){return{scrollWidth:0}},computed:{computedWidth:function(){return 100/this.days.length}},mounted:function(){this.init()},watch:{noScroll:function(e){!0===e?this.scrollWidth=0:this.$nextTick(this.onResize)}},methods:{init:function(){this.$nextTick(this.onResize)},onResize:function(){this.scrollWidth=this.getScrollWidth()},getScrollWidth:function(){var e=this.$refs.scrollArea,t=this.$refs.pane;return e&&t?e.offsetWidth-t.offsetWidth:0},__renderHead:function(e){var t=e("div",{staticClass:"q-calendar-daily__head",style:{marginRight:this.scrollWidth+"px"}},[this.__renderHeadIntervals(e)].concat(this.__renderHeadDays(e)));return!0===this.animated?e("transition",{props:{name:"q-transition--"+("prev"===this.direction?this.transitionPrev:this.transitionNext),appear:!0}},[t]):t},__renderHeadIntervals:function(e){var t=this,a=this.$scopedSlots["intervals-header"];return e("div",{staticClass:"q-calendar-daily__intervals-head q-calendar-daily__intervals-head--text",on:this.getDefaultMouseEventHandlers(":interval:header2",function(e){return{scope:{days:t.days},event:e}})},[a&&a(this.days)])},__renderHeadDays:function(e){var t=this;return 1===this.days.length&&void 0!==this.columnCount&&parseInt(this.columnCount,10)>0?Array.apply(null,new Array(parseInt(this.columnCount,10))).map(function(e,a){return a+parseInt(t.columnIndexStart,10)}).map(function(a){return t.__renderHeadDay(e,t.days[0],a)}):this.days.map(function(a){return t.__renderHeadDay(e,a)})},__renderHeadDay:function(e,t,a){var r=this,n=this.$scopedSlots["head-day"],i=this.$scopedSlots["day-header"],s=!0!==this.noActiveDate&&this.value===t.date,d=this.getScopeForSlot(t,a);d.activeDate=s;var o,u=this.computedWidth;return e("div",{key:t.date+(void 0!==a?"-"+a:""),staticClass:"q-calendar-daily__head-day",class:Object.assign({},this.getRelativeClasses(t),{"q-active-date":s,"q-calendar-daily__head-day--droppable":o}),style:{maxWidth:u+"%"},domProps:{ondragover:function(e){void 0!==r.dragOverFunc&&(o=r.dragOverFunc(e,t,"day",a))},ondrop:function(e){void 0!==r.dropFunc&&r.dropFunc(e,t,"day",a)}},on:Object.assign({},this.getDefaultMouseEventHandlers(":day:header2",function(e){return{scope:d,event:e}}))},[void 0!==n&&n(d),void 0===n&&!0===this.columnHeaderBefore&&this.__renderColumnHeaderBefore(e,t,a),void 0===n&&!0!==this.noDefaultHeaderText&&this.__renderHeadWeekday(e,t),void 0===n&&!0!==this.noDefaultHeaderBtn&&this.__renderHeadDayBtn(e,t),void 0===n&&i&&i(d),void 0===n&&!0===this.columnHeaderAfter&&this.__renderColumnHeaderAfter(e,t,a)])},__renderHeadWeekday:function(e,t){var a=this.$scopedSlots["day-header-label"],r=this.getScopeForSlot(t);return r.shortWeekdayLabel=this.shortWeekdayLabel,e("div",{staticClass:"ellipsis q-calendar-daily__head-weekday"},[a&&a(r)||this.__renderHeadDayLabel(e,t,this.shortWeekdayLabel)])},__renderHeadDayLabel:function(e,t,a){return e("span",{staticClass:"ellipsis"},this.weekdayFormatter(t,a))},__renderHeadDayBtn:function(e,t){var a=!0!==this.noActiveDate&&this.value===t.date,r=this.dayFormatter(t,!1),n=this.$scopedSlots["day-label"],i=this.$scopedSlots["day-btn"],s={dayLabel:r,timestamp:t,activeDate:a};return i?i(s):e(quasar.QBtn,{staticClass:"q-calendar-daily__head-day-label",props:{unelevated:!0,round:!0,dense:!0,noCaps:!0,outline:!0===t.current,disable:t.disabled},on:this.getDefaultMouseEventHandlers(":date2",function(e){return{scope:{timestamp:t},event:e}})},[n?n(s):r])},__renderColumnHeaderBefore:function(e,t,a){var r=this.$scopedSlots["column-header-before"],n={timestamp:t};return n.index=a,e("div",{staticClass:"q-calendar-daily__column-header--before"},[r&&r(n)])},__renderColumnHeaderAfter:function(e,t,a){var r=this.$scopedSlots["column-header-after"],n={timestamp:t};return n.index=a,e("div",{staticClass:"q-calendar-daily__column-header--after"},[r&&r(n)])},__renderBody:function(e){return e("div",{staticClass:"q-calendar-daily__body"},[this.__renderScrollArea(e)])},__renderScrollArea:function(e){return void 0!==this.noScroll&&!0===this.noScroll?this.__renderPane(e):e("div",{ref:"scrollArea",staticClass:"q-calendar-daily__scroll-area"},[this.__renderPane(e)])},__renderPane:function(e){return e("div",{ref:"pane",staticClass:"q-calendar-daily__pane",style:{height:convertToUnit(this.bodyHeight)}},[this.__renderDayContainer(e)])},__renderDayContainer:function(e){var t=this.$scopedSlots["day-container"],a=e("div",{staticClass:"q-calendar-daily__day-container"},[this.__renderBodyIntervals(e)].concat(this.__renderDays(e),[t&&t(this.days)]));return!0===this.animated?e("transition",{props:{name:"q-transition--"+("prev"===this.direction?this.transitionPrev:this.transitionNext),appear:!0}},[a]):a},__renderDays:function(e){var t=this;return 1===this.days.length&&this.columnCount&&parseInt(this.columnCount,10)>0?Array.apply(null,new Array(parseInt(this.columnCount,10))).map(function(e,a){return a+parseInt(t.columnIndexStart,10)}).map(function(a){return t.__renderDay(e,t.days[0],0,a)}):this.days.map(function(a,r){return t.__renderDay(e,a,r)})},__renderDay:function(e,t,a,r){var n=this,i=this.$scopedSlots["day-body"],s=this.getScopeForSlot(t,r),d=this.computedWidth;return e("div",{key:t.date+(void 0!==r?":"+r:""),staticClass:"q-calendar-daily__day",class:this.getRelativeClasses(t),style:{maxWidth:d+"%"},on:Object.assign({},this.getDefaultMouseEventHandlers(":time2",function(e){return{scope:n.getScopeForSlot(n.getTimestampAtEvent(e,t,n.timeClicksClamped),r),event:e}}))},this.__renderDayIntervals(e,a,r).concat([i&&i(s)]))},__renderDayIntervals:function(e,t,a){var r=this;return this.intervals[t].map(function(t){return r.__renderDayInterval(e,t,a)})},__renderDayInterval:function(e,t,a){var r,n=this,i=convertToUnit(this.intervalHeight),s=this.intervalStyle||this.intervalStyleDefault,d=this.$scopedSlots.interval,o=this.getScopeForSlot(t,a);return e("div",{key:getDateTime(t),staticClass:0===t.minute?"q-calendar-daily__day-interval":"q-calendar-daily__day-interval--section",class:Object.assign({},this.getIntervalClasses(t,this.selectedDates,this.selectedStartEndDates),{"q-calendar-daily__day-interval--droppable":r}),style:Object.assign({},{height:i},s(t)),domProps:{ondragover:function(e){void 0!==n.dragOverFunc&&(r=n.dragOverFunc(e,t,"interval",a))},ondrop:function(e){void 0!==n.dropFunc&&n.dropFunc(e,t,"interval",a)}}},d?d(o):void 0)},__renderBodyIntervals:function(e){var t=this;return e("div",{staticClass:"q-calendar-daily__intervals-body",on:Object.assign({},this.getDefaultMouseEventHandlers(":interval2",function(e){return{scope:{timestamp:t.getTimestampAtEvent(e,t.parsedStart,t.timeClicksClamped)},event:e}}))},this.__renderIntervalLabels(e))},__renderIntervalLabels:function(e){var t=this;return this.intervals[0].map(function(a){return t.__renderIntervalLabel(e,a)})},__renderIntervalLabel:function(e,t){var a=convertToUnit(this.intervalHeight),r=this.shortIntervalLabel,n=(this.showIntervalLabel||this.showIntervalLabelDefault)(t)?this.intervalFormatter(t,r):void 0;return e("div",{key:t.time,staticClass:"q-calendar-daily__interval",style:{height:a}},[e("div",{staticClass:"q-calendar-daily__interval-text"},n)])}},render:function(e){return e("div",{class:"q-calendar-daily",directives:[{modifiers:{quiet:!0},name:"resize",value:this.onResize}]},[!this.hideHeader&&this.__renderHead(e),this.__renderBody(e)])}},CalendarScheduler={name:"CalendarWithScheduler",mixins:[CalendarBase],props:Object.assign({},props.scheduler),computed:{parsedResourceHeight:function(){var e=parseFloat(this.resourceHeight);return 0===e?"auto":e},parsedResourceWidth:function(){return parseFloat(this.resourceWidth)},bodyHeight:function(){var e=this,t=0,a=function(t){var r=0;return t.forEach(function(t){r+=void 0!==t.height?t.height:e.parsedResourceHeight,t.children&&t.children.length>0&&!0===t.expanded&&(r+=a(t.children))}),r};return this.resources&&this.resources.length>0&&(t+=a(this.resources)),t},days:function(){return createDayList(this.parsedStart,this.parsedEnd,this.times.today,this.weekdaySkips,this.disabledBefore,this.disabledAfter,this.disabledWeekdays,this.disabledDays,this.maxDays)}},methods:{resourceStyleDefault:function(e){},getTimestampAtEvent:function(e,t){return updateRelative(copyTimestamp(t),this.times.now,!1)},getScopeForSlot:function(e,t,a){var r={timestamp:copyTimestamp(e)};return void 0!==t&&(r.index=t),void 0!==a&&(r.resource=a),r}}},mdiMenuRight$1="M10,17L15,12L10,7V17Z",mdiMenuDown$1="M7,10L12,15L17,10H7Z",QCalendarScheduler={name:"QCalendarScheduler",mixins:[CalendarScheduler],directives:{Resize:Resize},props:{direction:{type:String,default:"next"}},data:function(){return{scrollWidth:0}},created:function(){this.mdiMenuRight=mdiMenuRight$1,this.mdiMenuDown=mdiMenuDown$1},mounted:function(){this.init()},watch:{noScroll:function(e){!0===e?this.scrollWidth=0:this.$nextTick(this.onResize)}},computed:{isSticky:function(){return void 0!==this.cellWidth}},methods:{init:function(){this.$nextTick(this.onResize)},onResize:function(){this.scrollWidth=this.getScrollWidth()},getScrollWidth:function(){var e=this.$refs.scrollArea,t=this.$refs.pane;return e&&t?e.offsetWidth-t.offsetWidth:0},resourceStartPos:function(e,t){void 0===t&&(t=!0);var a=this.resource.indexOf(e)*this.parsedResourceHeight;return t&&(a<0&&(a=0),a>this.bodyHeight&&(a=this.bodyHeight)),a},__renderHead:function(e){var t=e("div",{staticClass:"q-calendar-scheduler__head"+(!0===this.isSticky?" q-calendar__sticky":""),style:{marginRight:this.getScrollWidth()+"px"}},[this.__renderHeadResources(e),this.__renderHeadDaysWrapper(e)]);return!0===this.animated?e("transition",{props:{name:"q-transition--"+("prev"===this.direction?this.transitionPrev:this.transitionNext),appear:!0}},[t]):t},__renderHeadResources:function(e){var t=this.$scopedSlots["scheduler-resources-header"],a=convertToUnit(this.parsedResourceWidth),r={days:this.days,resources:this.resources};return e("div",{staticClass:"q-calendar-scheduler__resource-head"+(!0===this.isSticky?" q-calendar__sticky":""),style:{minWidth:a,maxWidth:a},on:this.getDefaultMouseEventHandlers(":resource:header2",function(e){return{scope:r,event:e}})},[t&&t(this.days)])},__renderHeadDaysWrapper:function(e){return e("div",{staticClass:"q-calendar-scheduler__head-days-body"},[].concat(this.__renderHeadDays(e)))},__renderHeadDays:function(e){var t=this;return 1===this.days.length&&this.columnCount&&parseInt(this.columnCount,10)>0?Array.apply(null,new Array(parseInt(this.columnCount,10))).map(function(e,a){return a+parseInt(t.columnIndexStart,10)}).map(function(a){return t.__renderHeadDay(e,t.days[0],a)}):this.days.map(function(a){return t.__renderHeadDay(e,a)})},__renderHeadDay:function(e,t,a){var r=this,n=this.$scopedSlots["head-day"],i=this.$scopedSlots["scheduler-day-header"],s=!0!==this.noActiveDate&&this.value===t.date,d=this.getScopeForSlot(t,a);d.activeDate=s;var o,u=!0===this.isSticky?this.cellWidth:100/this.days.length+"%";return e("div",{key:t.date+(void 0!==a?":"+a:""),staticClass:"q-calendar-scheduler__head-day",class:Object.assign({},this.getRelativeClasses(t),{"q-active-date":s,"q-calendar-scheduler__head-day--droppable":o}),style:{minWidth:u,maxWidth:u},domProps:{ondragover:function(e){void 0!==r.dragOverFunc&&(o=r.dragOverFunc(e,t,"day",a))},ondrop:function(e){void 0!==r.dropFunc&&r.dropFunc(e,t,"day",a)}},on:this.getDefaultMouseEventHandlers(":day:header2",function(e){return{scope:d,event:e}})},[void 0!==n&&n(d),void 0===n&&!0===this.columnHeaderBefore&&this.__renderColumnHeaderBefore(e,t,a),void 0===n&&!0!==this.noDefaultHeaderText&&this.__renderHeadWeekday(e,t,a),void 0===n&&!0!==this.noDefaultHeaderBtn&&this.__renderHeadDayBtn(e,t,a),void 0===n&&i&&i(d),void 0===n&&!0===this.columnHeaderAfter&&this.__renderColumnHeaderAfter(e,t,a)])},__renderHeadWeekday:function(e,t){return e("div",{staticClass:"ellipsis q-calendar-scheduler__head-weekday"},[this.__renderHeadDayLabel(e,t,this.shortWeekdayLabel)])},__renderHeadDayLabel:function(e,t,a){return e("span",{staticClass:"ellipsis"},this.weekdayFormatter(t,a))},__renderHeadDayBtn:function(e,t,a){var r=!0!==this.noActiveDate&&this.value===t.date,n=this.dayFormatter(t,!1),i=this.$scopedSlots["day-label"],s=this.$scopedSlots["day-btn"],d={timestamp:t,index:a,dayLabel:n,activeDate:r};return s?s(d):e(quasar.QBtn,{staticClass:"q-calendar-scheduler__head-day-label",props:{unelevated:!0,round:!0,dense:!0,noCaps:!0,outline:!0===t.current,disable:t.disabled},on:this.getDefaultMouseEventHandlers(":date2",function(e){return{scope:{timestamp:t},event:e}})},[i?i(d):n])},__renderColumnHeaderBefore:function(e,t,a){var r=this.$scopedSlots["scheduler-column-header-before"],n={timestamp:t};return n.index=a,e("div",{staticClass:"q-calendar-scheduler__column-header--before"},[r&&r(n)])},__renderColumnHeaderAfter:function(e,t,a){var r=this.$scopedSlots["scheduler-column-header-after"],n={timestamp:t};return n.index=a,e("div",{staticClass:"q-calendar-scheduler__column-header--after"},[r&&r(n)])},__renderBody:function(e){var t=e("div",{staticClass:"q-calendar-scheduler__body"},[this.__renderScrollArea(e)]);return!0===this.animated?e("transition",{props:{name:"q-transition--"+("prev"===this.direction?this.transitionPrev:this.transitionNext),appear:!0}},[t]):t},__renderScrollArea:function(e){return void 0!==this.noScroll&&!0===this.noScroll?this.__renderPane(e):e("div",{ref:"scrollArea",staticClass:"q-calendar-scheduler__scroll-area"},[!0!==this.isSticky&&this.__renderPane(e),!0===this.isSticky&&this.__renderDayContainer(e)])},__renderPane:function(e){return e("div",{ref:"pane",staticClass:"q-calendar-scheduler__pane",style:{height:0===this.resourceHeight?"auto":convertToUnit(this.bodyHeight)}},[this.__renderDayContainer(e)])},__renderDayContainer:function(e){return e("div",{staticClass:"q-calendar-scheduler__day-container"},[!0===this.isSticky&&this.__renderHead(e),e("div",{staticClass:""},[this.__renderResources(e)])])},__renderResources:function(e,t,a){var r=this;return void 0===t&&(t=void 0),void 0===a&&(a=0),void 0===t&&(t=this.resources),t.map(function(t,n){return r.__renderResourceRow(e,t,n,a)})},__renderResourceRow:function(e,t,a,r){void 0===r&&(r=0);var n=e("div",{staticClass:"q-calendar-scheduler__resource-row",style:{height:void 0!==t.height?convertToUnit(t.height):convertToUnit(this.parsedResourceHeight)}},[this.__renderResource(e,t,a,r),this.__renderBodyResources(e,t,a,r)]);return!0===t.expanded?[n].concat(this.__renderResources(e,t.children,r+1)):[n]},__renderResource:function(e,t,a,r){return void 0===r&&(r=0),this.__renderResourceLabel(e,t,a,r)},__renderBodyResources:function(e,t,a,r){return e("div",{staticClass:"q-calendar-scheduler__resources-body",style:{width:convertToUnit(this.parsedResourceWidth)}},[].concat(this.__renderDays(e,t,a)))},__renderDays:function(e,t,a){var r=this;return 1===this.days.length&&this.columnCount&&parseInt(this.columnCount,10)>0?Array.apply(null,new Array(parseInt(this.columnCount,10))).map(function(e,t){return t+parseInt(r.columnIndexStart,10)}).map(function(a){return r.__renderDay(e,t,r.days[0],a)}):this.days.map(function(n,i){return r.__renderDay(e,t,n,i,a)})},__renderDay:function(e,t,a,r,n){var i=!0===this.isSticky?this.cellWidth:100/this.days.length+"%";return e("div",{key:a.date+(void 0!==n?":"+n:"")+(void 0!==r?":"+r:""),staticClass:"q-calendar-scheduler__day",class:this.getRelativeClasses(a),style:{minWidth:i,maxWidth:i}},[this.__renderDayResource(e,t,a,r,n)])},__renderDayResource:function(e,t,a,r,n){var i,s=this,d=this.resourceStyle||this.resourceStyleDefault,o=this.$scopedSlots["scheduler-resource-day"],u=this.getScopeForSlot(a,r,t),l=a.date+(void 0!==n?":"+n:"")+(void 0!==r?":"+r:""),c=d({timestamp:a,index:n,resource:t});return e("div",{key:l,staticClass:"q-calendar-scheduler__day-resource",class:{"q-calendar-scheduler__day-resource--droppable":i},style:c,domProps:{ondragover:function(e){void 0!==s.dragOverFunc&&(i=s.dragOverFunc(e,t,"resource",n))},ondrop:function(e){void 0!==s.dropFunc&&s.dropFunc(e,t,"resource",n)}},on:this.getDefaultMouseEventHandlers(":resource:day2",function(e){return{scope:s.getScopeForSlot(s.getTimestampAtEvent(e,a,s.timeClicksClamped),n,t),event:e}})},o?o(u):void 0)},__renderResourceLabel:function(e,t,a,r){var n=this;void 0===r&&(r=0);var i=this.$scopedSlots["scheduler-resource"],s={resource:t,index:a,days:this.days},d=convertToUnit(this.parsedResourceWidth),o=t[this.resourceKey];return void 0===o&&console.warn('QCalendarScheduler: resource object requires "resource-key" property to contain resource object key'),e("div",{key:o+(void 0!==a?":"+a:""),staticClass:"q-calendar-scheduler__resource"+(!0===this.isSticky?" q-calendar__sticky":""),style:{maxWidth:d,minWidth:d,height:"100%",paddingLeft:10*r+2+"px"},on:this.getDefaultMouseEventHandlers(":resource2",function(e){return{scope:s,event:e}})},[i?i(s):e("div",{staticClass:"q-calendar-scheduler__resource-text"},[t.children&&t.children.length>0&&e(quasar.QIcon,{props:{name:!0===t.expanded?this.mdiMenuDown:this.mdiMenuRight,size:"md"},on:{click:function(e){t.expanded=!t.expanded,e.stopPropagation(),n.$emit("expanded",t)}}}),o])])},__renderResourcesError:function(e){return e("div",{},"No resources have been defined")}},render:function(e){return e("div",{class:"q-calendar-scheduler",directives:[{modifiers:{quiet:!0},name:"resize",value:this.onResize}]},[!0!==this.isSticky&&!0!==this.hideHeader&&void 0!==this.resources&&this.__renderHead(e),void 0!==this.resources&&this.__renderBody(e),void 0===this.resources&&this.__renderResourcesError(e)])}},QCalendarAgenda={name:"QCalendarAgenda",mixins:[QCalendarDaily],props:Object.assign({},props.agenda),computed:{computedColumnCount:function(){return this.days.length+(!0===this.leftColumnOptionsValid?this.leftColumnOptions.length:0)+(!0===this.rightColumnOptionsValid?this.rightColumnOptions.length:0)},computedWidth:function(){return 100/this.computedColumnCount},leftColumnOptionsValid:function(){return void 0!==this.leftColumnOptions&&Array.isArray(this.leftColumnOptions)},rightColumnOptionsValid:function(){return void 0!==this.rightColumnOptions&&Array.isArray(this.rightColumnOptions)}},methods:{__renderHead:function(e){var t=e("div",{staticClass:"q-calendar-daily__head",style:{marginRight:this.scrollWidth+"px"}},this.__renderHeadDays(e));return!0===this.animated?e("transition",{props:{name:"q-transition--"+("prev"===this.direction?this.transitionPrev:this.transitionNext),appear:!0}},[t]):t},__renderHeadDays:function(e){var t=this;return 1===this.days.length&&void 0!==this.columnCount&&parseInt(this.columnCount,10)>0?[Array.apply(null,new Array(parseInt(this.columnCount,10))).map(function(e,a){return a+parseInt(t.columnIndexStart,10)}).map(function(a){return t.__renderHeadDay(e,t.days[0],a)})]:[!0===this.leftColumnOptionsValid&&this.leftColumnOptions.map(function(a,r){return t.__renderColumnHead(e,a,r)}),this.days.map(function(a){return t.__renderHeadDay(e,a)}),!0===this.rightColumnOptionsValid&&this.rightColumnOptions.map(function(a,r){return t.__renderColumnHead(e,a,r)})]},__renderPane:function(e){return e("div",{ref:"pane",staticClass:"q-calendar-daily__pane",style:{}},[this.__renderDayContainer(e)])},__renderBodyIntervals:function(e){},__renderColumnHead:function(e,t,a){var r,n=this,i=this.$scopedSlots["column-header"],s=t,d=this.computedWidth;return e("div",{key:void 0!==this.columnOptionsId?t[this.columnOptionsId]:void 0,staticClass:"q-calendar-daily__head-day",class:{"q-column-day":!0,"q-calendar-daily__head-day--droppable":r},style:{maxWidth:d+"%"},domProps:{ondragover:function(e){void 0!==n.dragOverFunc&&(r=n.dragOverFunc(e,t,"column",a))},ondrop:function(e){void 0!==n.dropFunc&&n.dropFunc(e,t,"column",a)}},on:this.getDefaultMouseEventHandlers(":column:header2",function(e,r){return{scope:{column:t,index:a},event:e}})},[!0!==this.noDefaultHeaderText&&this.__renderHeadColumn(e,t),i&&i(s)])},__renderHeadColumn:function(e,t){var a=this.$scopedSlots["column-header-label"];return e("div",{staticClass:"ellipsis q-calendar-daily__head-weekday"},[a&&a(t),!a&&this.__renderHeadColumnLabel(e,void 0!==this.columnOptionsLabel?t[this.columnOptionsLabel]:t.label)])},__renderHeadColumnLabel:function(e,t){return e("span",{staticClass:"ellipsis"},t)},__renderDays:function(e){var t=this;return 1===this.days.length&&this.columnCount&&parseInt(this.columnCount,10)>0?[Array.apply(null,new Array(parseInt(this.columnCount,10))).map(function(e,a){return a+parseInt(t.columnIndexStart,10)}).map(function(a){return t.__renderDay(e,t.days[0],0,a)})]:[!0===this.leftColumnOptionsValid&&this.leftColumnOptions.map(function(a,r){return t.__renderColumn(e,a,r)}),this.days.map(function(a,r){return t.__renderDay(e,a,r)}),!0===this.rightColumnOptionsValid&&this.rightColumnOptions.map(function(a,r){return t.__renderColumn(e,a,r)})]},__renderColumn:function(e,t,a){var r,n=this,i=this.$scopedSlots["column-body"],s={column:t,index:a},d=this.computedWidth;return e("div",{key:void 0!==this.columnOptionsId?t[this.columnOptionsId]:void 0,staticClass:"q-calendar-daily__day",class:{"q-column-day":!0,"q-calendar-daily__day--droppable":r},style:{maxWidth:d+"%"},domProps:{ondragover:function(e){void 0!==n.dragOverFunc&&(r=n.dragOverFunc(e,t,"column"))},ondrop:function(e){void 0!==n.dropFunc&&n.dropFunc(e,t,"column")}},on:this.getDefaultMouseEventHandlers(":column2",function(e,t){return t.indexOf("2"),{scope:s,event:e}})},[i&&i(s)])},__renderDay:function(e,t,a,r){var n,i=this,s=this.$scopedSlots["day-body"],d={timestamp:t},o=this.computedWidth;return e("div",{key:t.date+(void 0!==r?":"+r:""),staticClass:"q-calendar-daily__day",class:Object.assign({},this.getRelativeClasses(t),{"q-calendar-daily__day--droppable":n}),style:{maxWidth:o+"%"},domProps:{ondragover:function(e){void 0!==i.dragOverFunc&&(n=i.dragOverFunc(e,t,"day"))},ondrop:function(e){void 0!==i.dropFunc&&i.dropFunc(e,t,"day")}},on:this.getDefaultMouseEventHandlers(":time2",function(e,a){var n=i.getScopeForSlot(i.getTimestampAtEvent(e,t,i.timeClicksClamped),r);return n.index=r,{scope:n,event:e}})},[s&&s(d)])}},render:function(e){return e("div",{class:"q-calendar-agenda"},[!this.hideHeader&&this.__renderHead(e),this.__renderBody(e)])}},mdiMenuRight="M10,17L15,12L10,7V17Z",mdiMenuDown="M7,10L12,15L17,10H7Z",QCalendarResource={name:"QCalendarResource",mixins:[CalendarIntervals],props:Object.assign({},props.intervals,props.resource,{direction:{type:String,default:"next"}}),data:function(){return{minWidth:"100px"}},created:function(){this.mdiMenuRight=mdiMenuRight,this.mdiMenuDown=mdiMenuDown},computed:{parsedResourceHeight:function(){var e=parseFloat(this.resourceHeight);return 0===e?"auto":e},parsedResourceWidth:function(){return parseFloat(this.resourceWidth)},parsedIntervalHeight:function(){var e=parseFloat(this.intervalHeight);return 0===e?"auto":e}},methods:{__renderHeadIntervals:function(e){var t=this;return e("div",{staticClass:"q-calendar-resource__head-intervals"},[this.intervals.map(function(a){return a.map(function(a,r){return t.__renderHeadInterval(e,a,r)})})])},__renderHeadInterval:function(e,t,a){var r,n=this,i=convertToUnit(this.parsedIntervalWidth),s=convertToUnit(this.parsedIntervalHeight),d=this.$scopedSlots["interval-label"],o=this.shortIntervalLabel,u=this.intervalFormatter(t,o);return d?d({interval:t,index:a,label:u}):e("div",{staticClass:"q-calendar-resource__head-label",class:{"q-calendar-resource__head-label--droppable":r},style:{maxWidth:i,minWidth:i,height:s},domProps:{ondragover:function(e){void 0!==n.dragOverFunc&&(r=n.dragOverFunc(e,t,"interval",a))},ondrop:function(e){void 0!==n.dropFunc&&n.dropFunc(e,t,"interval",a)}},on:this.getDefaultMouseEventHandlers(":interval2",function(e,r){return{scope:{timestamp:t,index:a,label:u},event:e}})},u)},__renderBody:function(e){return e("div",{staticClass:"q-calendar-resource__body"},[this.__renderScrollArea(e)])},__renderScrollArea:function(e){return e("div",{ref:"scrollArea",staticClass:"q-calendar-resource__scroll-area"},[this.__renderDayContainer(e)])},__renderHead:function(e){return e("div",{staticClass:"q-calendar-resource__head"+(!0===this.sticky?" q-calendar__sticky":"")},[this.__renderHeadResource(e),this.__renderHeadIntervals(e)])},__renderHeadResource:function(e){var t=this.$scopedSlots["resource-header"],a=convertToUnit(this.parsedResourceWidth),r=convertToUnit(this.parsedIntervalHeight),n={timestamp:this.days[0],resources:this.resources,intervals:this.intervals[0]},i=this.intervals;return e("div",{staticClass:"q-calendar-resource__resource-head"+(!0===this.sticky?" q-calendar__sticky":""),style:{maxWidth:a,minWidth:a,height:r},on:this.getDefaultMouseEventHandlers(":resource:header2",function(e){return{scope:n,event:e}})},[t&&t({date:this.value,intervals:i})])},__renderDayContainer:function(e){var t=e("div",{staticClass:"q-calendar-resource__day-container"},[this.__renderHead(e),void 0===this.resources&&this.__renderResourcesError(e),void 0!==this.resources&&this.__renderBodyResources(e)]);return!0===this.animated?e("transition",{props:{name:"q-transition--"+("prev"===this.direction?this.transitionPrev:this.transitionNext),appear:!0}},[t]):t},__renderBodyResources:function(e){return e("div",{staticClass:"q-calendar-resource__resources-body"},this.__renderResources(e))},__renderResources:function(e,t,a){var r=this;return void 0===t&&(t=void 0),void 0===a&&(a=0),void 0===t&&(t=this.resources),t.map(function(t,n){return r.__renderResourceRow(e,t,n,a)})},__renderResourceRow:function(e,t,a,r){void 0===r&&(r=0);var n=this.$scopedSlots["resource-row"],i=e("div",{staticClass:"q-calendar-resource__resource-row"},[this.__renderResourceLabel(e,t,a,r),this.__renderResourceIntervals(e,t,a),n&&n({resource:t,index:a})]);return!0===t.expanded?[i].concat(this.__renderResources(e,t.children,r+1)):[i]},__renderResourceLabel:function(e,t,a,r){var n=this;void 0===r&&(r=0);var i=this.$scopedSlots["resource-label"],s={resource:t,index:a},d=convertToUnit(this.parsedResourceWidth),o=void 0!==t.height?convertToUnit(t.height):convertToUnit(this.parsedResourceHeight);return e("div",{key:t[this.resourceKey]+"-"+a,staticClass:"q-calendar-resource__resource"+(!0===this.sticky?" q-calendar__sticky":""),style:{maxWidth:d,minWidth:d,height:o},on:this.getDefaultMouseEventHandlers(":resource2",function(e,r){return{scope:{resource:t,index:a,intervals:n.intervals},event:e}})},[i?i(s):this.__renderResourceText(e,t,a,r)])},__renderResourceText:function(e,t,a,r){var n=this;void 0===r&&(r=0);var i=t[this.resourceKey];return void 0===i&&console.warn('QCalendarResource: resource object requires "resource-key" property to contain resource object key'),e("div",{staticClass:"q-calendar-resource__resource-text",style:{paddingLeft:10*r+"px"}},[t.children&&t.children.length>0&&e(quasar.QIcon,{props:{name:!0===t.expanded?this.mdiMenuDown:this.mdiMenuRight,size:"md"},on:{click:function(e){t.expanded=!t.expanded,e.stopPropagation(),n.$emit("expanded",t)}}}),i])},__renderResourceIntervals:function(e,t,a){var r=this,n=this.$scopedSlots["resource-intervals"],i=this.timeStartPosX,s=this.timeDurationWidth,d=this.intervals;return e("div",{staticClass:"q-calendar-resource__resource-intervals"},[this.intervals.map(function(n){return n.map(function(n){return r.__renderResourceInterval(e,t,n,a)})}),n&&n({resource:t,intervals:d,timeStartPosX:i,timeDurationWidth:s})])},__renderResourceInterval:function(e,t,a,r){var n,i=this,s=this.$scopedSlots["resource-interval"],d={resource:t,interval:a},o=convertToUnit(this.parsedIntervalWidth),u=void 0!==t.height?convertToUnit(t.height):convertToUnit(this.parsedResourceHeight);return e("div",{staticClass:"q-calendar-resource__resource-interval",class:{"q-calendar-resource__resource-interval--droppable":n},style:{maxWidth:o,minWidth:o,height:u},domProps:{ondragover:function(e){void 0!==i.dragOverFunc&&(n=i.dragOverFunc(e,a,"resource",t))},ondrop:function(e){void 0!==i.dropFunc&&i.dropFunc(e,a,"resource",t)}},on:this.getDefaultMouseEventHandlers(":time2",function(e,n){var s=i.getScopeForSlotX(i.getTimestampAtEventX(e,a,i.timeClicksClamped));return s.resource=t,s.index=r,{scope:s,event:e}})},[s&&s(d)])},__renderResourcesError:function(e){return e("div",{},"No resources have been defined")}},render:function(e){return e("div",{class:"q-calendar-resource"},[this.__renderBody(e)])}},QCalendar={name:"QCalendar",mixins:[CalendarBase],props:Object.assign({},props.base,props.calendar,props.weeks,props.intervals,props.scheduler,props.resource,props.agenda),data:function(){return{lastStart:void 0,lastEnd:void 0,emittedValue:""}},computed:{__parsedValue:function(){return parseTimestamp(this.value)||this.parsedStart||this.times.today},__renderProps:function(){var e=this.__parsedValue,t="div",a=this.maxDays,r=e,n=e;switch(this.view){case"month":t=QCalendarMonthly,r=getStartOfMonth(e),n=getEndOfMonth(e);break;case"week":case"week-agenda":case"week-scheduler":t=this.view.endsWith("-agenda")?QCalendarAgenda:this.view.endsWith("-scheduler")?QCalendarScheduler:QCalendarDaily,r=this.getStartOfWeek(e),n=this.getEndOfWeek(r),a=this.weekdays.length;break;case"day":case"day-scheduler":case"day-agenda":t=this.view.endsWith("-agenda")?QCalendarAgenda:this.view.endsWith("-scheduler")?QCalendarScheduler:QCalendarDaily,a=1,updateFormatted(n=relativeDays(copyTimestamp(n),nextDay,a,this.weekdays));break;case"2day":case"2day-scheduler":case"2day-agenda":t=this.view.endsWith("-agenda")?QCalendarAgenda:this.view.endsWith("-scheduler")?QCalendarScheduler:QCalendarDaily,a=2,updateFormatted(n=relativeDays(copyTimestamp(n),nextDay,a,this.weekdays));break;case"3day":case"3day-scheduler":case"3day-agenda":t=this.view.endsWith("-agenda")?QCalendarAgenda:this.view.endsWith("-scheduler")?QCalendarScheduler:QCalendarDaily,a=3,updateFormatted(n=relativeDays(copyTimestamp(n),nextDay,a,this.weekdays));break;case"4day":case"4day-scheduler":case"4day-agenda":t=this.view.endsWith("-agenda")?QCalendarAgenda:this.view.endsWith("-scheduler")?QCalendarScheduler:QCalendarDaily,a=4,updateFormatted(n=relativeDays(copyTimestamp(n),nextDay,a,this.weekdays));break;case"5day":case"5day-scheduler":case"5day-agenda":t=this.view.endsWith("-agenda")?QCalendarAgenda:this.view.endsWith("-scheduler")?QCalendarScheduler:QCalendarDaily,a=5,updateFormatted(n=relativeDays(copyTimestamp(n),nextDay,a,this.weekdays));break;case"6day":case"6day-scheduler":case"6day-agenda":t=this.view.endsWith("-agenda")?QCalendarAgenda:this.view.endsWith("-scheduler")?QCalendarScheduler:QCalendarDaily,a=6,updateFormatted(n=relativeDays(copyTimestamp(n),nextDay,a,this.weekdays));break;case"custom-interval":case"custom-scheduler":case"custom-agenda":t=this.view.endsWith("-agenda")?QCalendarAgenda:this.view.endsWith("-scheduler")?QCalendarScheduler:QCalendarDaily,updateFormatted(n=relativeDays(copyTimestamp(n),nextDay,this.maxDays,this.weekdays));break;case"scheduler":case"agenda":t="scheduler"===this.view?QCalendarScheduler:QCalendarAgenda,updateFormatted(n=relativeDays(copyTimestamp(n),nextDay,this.maxDays,this.weekdays));break;case"month-interval":case"month-scheduler":case"month-agenda":t=this.view.endsWith("-agenda")?QCalendarAgenda:this.view.endsWith("-scheduler")?QCalendarScheduler:QCalendarDaily,r=getStartOfMonth(e),updateFormatted(n=getEndOfMonth(e)),a=DAYS_IN_MONTH_MAX;break;case"resource":case"day-resource":t=QCalendarResource,a=1,updateFormatted(n=relativeDays(copyTimestamp(n),nextDay,a,this.weekdays))}return{component:t,start:r,end:n,maxDays:a}},__isMiniMode:function(){return!0===this.miniMode||"auto"===this.miniMode&&void 0!==this.breakpoint&&this.$q.screen.lt[this.breakpoint]}},beforeMount:function(){this.emittedValue=this.value,this.__checkChange()},watch:{__renderProps:"__checkChange",emittedValue:function(e,t){this.$emit("input",e)}},methods:{__checkChange:function(){var e=this.__renderProps,t=e.start,a=e.end;this.keyValue=0,void 0!==this.lastStart&&void 0!==this.lastEnd&&t.date===this.lastStart&&a.date===this.lastEnd||(this.lastStart=t.date,this.lastEnd=a.date,this.$emit("change",{start:t,end:a})),this.keyValue=getDayIdentifier(t)},move:function(e){if(void 0===e&&(e=1),0!==e){var t=copyTimestamp(this.__parsedValue),a=e>0,r=a?nextDay:prevDay,n=a?DAYS_IN_MONTH_MAX:DAY_MIN,i=a?e:-e;this.direction=a?"next":"prev";this.maxDays;for(var s=this.weekdaySkips.filter(function(e){return 0!==e}).length;--i>=0;)switch(this.view){case"month":t.day=n,r(t);break;case"week":case"week-scheduler":case"week-agenda":case"scheduler":relativeDays(t,r,s,this.weekdays);break;case"day":case"day-scheduler":case"day-agenda":relativeDays(t,r,1,this.weekdays);break;case"2day":case"2day-scheduler":case"2day-agenda":relativeDays(t,r,2,this.weekdays);break;case"3day":case"3day-scheduler":case"3day-agenda":relativeDays(t,r,3,this.weekdays);break;case"4day":case"4day-scheduler":case"4day-agenda":relativeDays(t,r,4,this.weekdays);break;case"5day":case"5day-scheduler":case"5day-agenda":relativeDays(t,r,5,this.weekdays);break;case"6day":case"6day-scheduler":case"6day-agenda":relativeDays(t,r,6,this.weekdays);break;case"custom-interval":case"custom-scheduler":case"custom-agenda":case"agenda":relativeDays(t,r,this.maxDays,this.weekdays);break;case"month-interval":case"month-agenda":case"month-scheduler":t.day=n,r(t);break;case"resource":case"day-resource":relativeDays(t,r,1,this.weekdays)}updateWeekday(t),updateFormatted(t),updateDayOfYear(t),updateRelative(t,this.times.now),this.emittedValue=t.date,this.$emit("moved",t)}else this.moveToToday()},moveToToday:function(){this.emittedValue=today()},next:function(e){void 0===e&&(e=1),this.move(e)},prev:function(e){void 0===e&&(e=1),this.move(-e)},timeStartPos:function(e,t){void 0===t&&(t=!0);var a=this.$children[0];return!(!a||!a.timeStartPos)&&a.timeStartPos(e,t)},timeStartPosX:function(e,t){void 0===t&&(t=!0);var a=this.$children[0];return!(!a||!a.timeStartPosX)&&a.timeStartPosX(e,t)},timeDurationHeight:function(e){var t=this.$children[0];return t&&t.timeDurationHeight?t.timeDurationHeight(e):-1},timeDurationWidth:function(e){var t=this.$children[0];return t&&t.timeDurationWidth?t.timeDurationWidth(e):-1},heightToMinutes:function(e){var t=this.$children[0];return t&&t.heightToMinutes?t.heightToMinutes(e):-1},widthToMinutes:function(e){var t=this.$children[0];return t&&t.widthToMinutes?t.widthToMinutes(e):-1},scrollToTime:function(e){var t=this.$children[0];return!(!t||!t.scrollToTime)&&t.scrollToTime(e)},scrollToTimeX:function(e){var t=this.$children[0];return!(!t||!t.scrollToTimeX)&&t.scrollToTimeX(e)},__renderComponent:function(e,t,a){return e(t,a)}},render:function(e){var t=this,a=this.__renderProps,r=a.start,n=a.end,i=a.maxDays,s=a.component;this.keyValue=getDayIdentifier(r);var d={staticClass:!0===this.__isMiniMode?"q-calendar-mini":"",class:{"q-calendar__bordered":this.bordered},key:this.keyValue,props:Object.assign({},this.$props,{direction:this.direction,start:r.date,end:n.date,maxDays:i}),on:Object.assign({},this.$listeners,{"click:date2":function(e){var a=e.scope,r=e.event;void 0!==t.$listeners.input&&void 0!==a.timestamp.date&&t.emittedValue!==a.timestamp.date&&(t.emittedValue=a.timestamp.date),t.$listeners["click:date2"]&&t.$emit("click:date2",{scope:a,event:r})}}),scopedSlots:this.$scopedSlots};return e("div",{class:{"q-calendar--dark":!0===this.dark,"q-calendar":!0}},[this.__renderComponent(e,s,d)])}},Plugin={version:version,QCalendar:QCalendar,PARSE_REGEX:PARSE_REGEX,PARSE_TIME:PARSE_TIME,DAYS_IN_MONTH:DAYS_IN_MONTH,DAYS_IN_MONTH_LEAP:DAYS_IN_MONTH_LEAP,DAYS_IN_MONTH_MIN:DAYS_IN_MONTH_MIN,DAYS_IN_MONTH_MAX:DAYS_IN_MONTH_MAX,MONTH_MAX:MONTH_MAX,MONTH_MIN:MONTH_MIN,DAY_MIN:DAY_MIN,DAYS_IN_WEEK:DAYS_IN_WEEK,MINUTES_IN_HOUR:MINUTES_IN_HOUR,HOURS_IN_DAY:HOURS_IN_DAY,FIRST_HOUR:FIRST_HOUR,MILLISECONDS_IN_MINUTE:MILLISECONDS_IN_MINUTE,MILLISECONDS_IN_HOUR:MILLISECONDS_IN_HOUR,MILLISECONDS_IN_DAY:MILLISECONDS_IN_DAY,MILLISECONDS_IN_WEEK:MILLISECONDS_IN_WEEK,Timestamp:Timestamp,TimeObject:TimeObject,today:today,getStartOfWeek:getStartOfWeek,getEndOfWeek:getEndOfWeek,getStartOfMonth:getStartOfMonth,getEndOfMonth:getEndOfMonth,parseTime:parseTime,validateTimestamp:validateTimestamp,parsed:parsed,parseTimestamp:parseTimestamp,parseDate:parseDate,getDayIdentifier:getDayIdentifier,getTimeIdentifier:getTimeIdentifier,getDayTimeIdentifier:getDayTimeIdentifier,diffTimestamp:diffTimestamp,updateRelative:updateRelative,updateMinutes:updateMinutes,updateWeekday:updateWeekday,updateDayOfYear:updateDayOfYear,updateWorkWeek:updateWorkWeek,updateDisabled:updateDisabled,updateFormatted:updateFormatted,getDayOfYear:getDayOfYear,getWorkWeek:getWorkWeek,getWeekday:getWeekday,isLeapYear:isLeapYear,daysInMonth:daysInMonth,copyTimestamp:copyTimestamp,padNumber:padNumber,getDate:getDate,getTime:getTime,getDateTime:getDateTime,nextDay:nextDay,prevDay:prevDay,relativeDays:relativeDays,moveRelativeDays:moveRelativeDays,findWeekday:findWeekday,getWeekdaySkips:getWeekdaySkips,createDayList:createDayList,createIntervalList:createIntervalList,createNativeLocaleFormatter:createNativeLocaleFormatter,makeDate:makeDate,makeDateTime:makeDateTime,validateNumber:validateNumber,isBetweenDates:isBetweenDates,isOverlappingDates:isOverlappingDates,daysBetween:daysBetween,weeksBetween:weeksBetween,addToDate:addToDate,compareTimestamps:compareTimestamps,compareDate:compareDate,compareTime:compareTime,compareDateTime:compareDateTime,convertToUnit:convertToUnit,indexOf:indexOf,install:function(e){e.component(QCalendar.name,QCalendar)}};module.exports=Plugin;